from typing import Iterable, List, Optional, Tupleimport clickimport numpy as npimport rospyfrom scipy.spatial.transform import Rotation as Rfrom home_robot.manipulation.voxel_grasps import VoxelGraspGeneratorfrom home_robot.mapping.voxel import SparseVoxelMapfrom home_robot.utils.point_cloud import show_point_cloudfrom home_robot_hw.ros.grasp_helper import GraspServer@click.command()@click.option("--debug", default=False, is_flag=True)def inference(debug):    """    Predict 6-DoF grasp distribution for given point cloud with a heuristic    Heuristic is as follows:        1. Voxelize the point cloud        2. Extract the top 10% voxels with highest Z coordinates in world frame        3. Project the said voxels into a 2D occupancy map        4. Compute grasp scores for each voxel based on neighboring occupancies        5. Generate top-down grasps if score > threshold    """    in_base_frame = True  # produced grasps are in base frame    grasp_generator = VoxelGraspGenerator(in_base_frame, debug)    # Initialize server    _ = GraspServer(grasp_generator.get_grasps)    # Spin    rospy.spin()    rate = rospy.Rate(10)    while not rospy.is_shutdown():        rate.sleep()        continueif __name__ == "__main__":    rospy.init_node("simple_grasp_server")    inference()