import loggingimport osfrom .command import Commandfrom appimagebuilder.recipe.roamer import Roamerfrom appimagebuilder.modules.test import ExecutionTest, TestFailedfrom ..context import Contextimport dockerfrom docker.errors import DockerExceptionclass RunTestCommand(Command):    def __init__(self, context: Context, tests_settings: Roamer):        super().__init__(context, "AppDir tests")        self.app_dir = context.app_dir        self.tests_settings = tests_settings    def id(self):        return "test"    def __call__(self, *args, **kwargs):        try:            test_cases = self._load_tests(self.tests_settings())        except DockerException as e:            logging.error("Docker error : "+str(e))            logging.error("(Is docker installed/started ?)")            logging.error("Tests will be skipped")            return        try:            for test in test_cases:                test.run()        except TestFailed as err:            logging.error("test failed")            logging.error(err)            exit(1)    def _load_tests(self, test_settings: {}):        test_cases = []        for name, data in test_settings.items():            data_accessor = Roamer(data)            env = data_accessor.env() or []            if isinstance(env, dict):                env = ["%s=%s" % (k, v) for k, v in env.items()]            test = ExecutionTest(                appdir=self.app_dir,                name=name,                image=data_accessor.image(),                command=data_accessor.command(),                before_command=data_accessor.before_command(),                env=env,            )            test_cases.append(test)        return test_cases