# Copyright (c) Meta Platforms, Inc. and affiliates.# Permission is hereby granted, free of charge, to any person obtaining a copy# of this software and associated documentation files (the "Software"), to deal# in the Software without restriction, including without limitation the rights# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell# copies of the Software, and to permit persons to whom the Software is# furnished to do so, subject to the following conditions:# The above copyright notice and this permission notice shall be included in all# copies or substantial portions of the Software.# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE# SOFTWARE."""Ref: https://github.com/ScanNet/ScanNet/blob/master/BenchmarkScripts"""import csvimport osimport numpy as npfrom plyfile import PlyDatadef represents_int(s):    """Judge whether string s represents an int.    Args:        s(str): The input string to be judged.    Returns:        bool: Whether s represents int or not.    """    try:        int(s)        return True    except ValueError:        return Falsedef read_label_mapping(filename, label_from="raw_category", label_to="nyu40id"):    assert os.path.isfile(filename)    mapping = dict()    with open(filename) as csvfile:        reader = csv.DictReader(csvfile, delimiter="\t")        for row in reader:            mapping[row[label_from]] = int(row[label_to])    if represents_int(list(mapping.keys())[0]):        mapping = {int(k): v for k, v in mapping.items()}    return mappingdef read_mesh_vertices(filename):    """Read XYZ for each vertex.    Args:        filename(str): The name of the mesh vertices file.    Returns:        ndarray: Vertices.    """    assert os.path.isfile(filename)    with open(filename, "rb") as f:        plydata = PlyData.read(f)        num_verts = plydata["vertex"].count        vertices = np.zeros(shape=[num_verts, 3], dtype=np.float32)        vertices[:, 0] = plydata["vertex"].data["x"]        vertices[:, 1] = plydata["vertex"].data["y"]        vertices[:, 2] = plydata["vertex"].data["z"]    return verticesdef read_mesh_vertices_rgb(filename):    """Read XYZ and RGB for each vertex.    Args:        filename(str): The name of the mesh vertices file.    Returns:        Vertices. Note that RGB values are in 0-255.    """    assert os.path.isfile(filename)    with open(filename, "rb") as f:        plydata = PlyData.read(f)        num_verts = plydata["vertex"].count        vertices = np.zeros(shape=[num_verts, 6], dtype=np.float32)        vertices[:, 0] = plydata["vertex"].data["x"]        vertices[:, 1] = plydata["vertex"].data["y"]        vertices[:, 2] = plydata["vertex"].data["z"]        vertices[:, 3] = plydata["vertex"].data["red"]        vertices[:, 4] = plydata["vertex"].data["green"]        vertices[:, 5] = plydata["vertex"].data["blue"]    return vertices