# MIT License## Copyright (c) 2019 cybertronai## Permission is hereby granted, free of charge, to any person obtaining a copy# of this software and associated documentation files (the "Software"), to deal# in the Software without restriction, including without limitation the rights# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell# copies of the Software, and to permit persons to whom the Software is# furnished to do so, subject to the following conditions:## The above copyright notice and this permission notice shall be included in all# copies or substantial portions of the Software.## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE# SOFTWARE."""Lamb optimizer."""import collectionsimport mathimport torchfrom torch.optim import Optimizerclass Lamb(Optimizer):    r"""Implements Lamb algorithm.    It has been proposed in `Large Batch Optimization for Deep Learning: Training BERT in 76 minutes`_.    Arguments:        params (iterable): iterable of parameters to optimize or dicts defining            parameter groups        lr (float, optional): learning rate (default: 1e-3)        betas (Tuple[float, float], optional): coefficients used for computing            running averages of gradient and its square (default: (0.9, 0.999))        eps (float, optional): term added to the denominator to improve            numerical stability (default: 1e-8)        weight_decay (float, optional): weight decay (L2 penalty) (default: 0)        adam (bool, optional): always use trust ratio = 1, which turns this into            Adam. Useful for comparison purposes.    .. _Large Batch Optimization for Deep Learning: Training BERT in 76 minutes:        https://arxiv.org/abs/1904.00962    LAMB optimizer used as is from primary source.    2ndary source: https://github.com/peract/peract/blob/main/helpers/optim/lamb.py    Source: https://github.com/cybertronai/pytorch-lamb    License: https://github.com/cybertronai/pytorch-lamb/blob/master/LICENSE    Note: Also available at https://github.com/jettify/pytorch-optimizer    """    def __init__(        self,        params,        lr=1e-3,        betas=(0.9, 0.999),        eps=1e-6,        weight_decay=0,        adam=False,    ):        if not 0.0 <= lr:            raise ValueError("Invalid learning rate: {}".format(lr))        if not 0.0 <= eps:            raise ValueError("Invalid epsilon value: {}".format(eps))        if not 0.0 <= betas[0] < 1.0:            raise ValueError("Invalid beta parameter at index 0: {}".format(betas[0]))        if not 0.0 <= betas[1] < 1.0:            raise ValueError("Invalid beta parameter at index 1: {}".format(betas[1]))        defaults = dict(lr=lr, betas=betas, eps=eps, weight_decay=weight_decay)        self.adam = adam        super(Lamb, self).__init__(params, defaults)    def step(self, closure=None):        """Performs a single optimization step.        Arguments:            closure (callable, optional): A closure that reevaluates the model                and returns the loss.        """        loss = None        if closure is not None:            loss = closure()        for group in self.param_groups:            for p in group["params"]:                if p.grad is None:                    continue                grad = p.grad.data                if grad.is_sparse:                    raise RuntimeError(                        "Lamb does not support sparse gradients, consider SparseAdam instad."                    )                state = self.state[p]                # State initialization                if len(state) == 0:                    state["step"] = 0                    # Exponential moving average of gradient values                    state["exp_avg"] = torch.zeros_like(p.data)                    # Exponential moving average of squared gradient values                    state["exp_avg_sq"] = torch.zeros_like(p.data)                exp_avg, exp_avg_sq = state["exp_avg"], state["exp_avg_sq"]                beta1, beta2 = group["betas"]                state["step"] += 1                # Decay the first and second moment running average coefficient                # m_t                exp_avg.mul_(beta1).add_(grad, alpha=1 - beta1)                # v_t                exp_avg_sq.mul_(beta2).addcmul_(grad, grad, value=1 - beta2)                # Paper v3 does not use debiasing.                # bias_correction1 = 1 - beta1 ** state['step']                # bias_correction2 = 1 - beta2 ** state['step']                # Apply bias to lr to avoid broadcast.                step_size = group[                    "lr"                ]  # * math.sqrt(bias_correction2) / bias_correction1                weight_norm = p.data.pow(2).sum().sqrt().clamp(0, 10)                adam_step = exp_avg / exp_avg_sq.sqrt().add(group["eps"])                if group["weight_decay"] != 0:                    adam_step.add_(p.data, alpha=group["weight_decay"])                adam_norm = adam_step.pow(2).sum().sqrt()                if weight_norm == 0 or adam_norm == 0:                    trust_ratio = 1                else:                    trust_ratio = weight_norm / adam_norm                state["weight_norm"] = weight_norm                state["adam_norm"] = adam_norm                state["trust_ratio"] = trust_ratio                if self.adam:                    trust_ratio = 1                p.data.add_(adam_step, alpha=-step_size * trust_ratio)        return loss