"""This file is a test for inverse kinematics on the stretch robot. It makes sure we can reach and execute different positions, which have been generated by the grasp planner. It's a useful utility for now."""import clickimport numpy as npimport rospyfrom geometry_msgs.msg import TransformStampedfrom home_robot.agent.ovmm_agent.pick_and_place_agent import PickAndPlaceAgentfrom home_robot.core.interfaces import DiscreteNavigationActionfrom home_robot.motion.stretch import STRETCH_HOME_Qfrom home_robot.utils.config import get_configfrom home_robot.utils.geometry import posquat2sophus, sophus2posquat, xyt2sophusfrom home_robot.utils.pose import to_pos_quatfrom home_robot_hw.env.stretch_pick_and_place_env import (    StretchPickandPlaceEnv,    load_config,)from home_robot_hw.ros.utils import matrix_to_pose_msg, ros_pose_to_transformdef _send_predicted_grasp_to_tf(grasp_planner, frame_name, grasp_matrix):    """Helper function for visualizing the predicted grasps."""    # Convert grasp pose to pos/quaternion    # Visualize the grasp in RViz    t = TransformStamped()    t.header.stamp = rospy.Time.now()    t.child_frame_id = frame_name    t.header.frame_id = "base_link"    t.transform = ros_pose_to_transform(matrix_to_pose_msg(grasp_matrix))    grasp_planner.grasp_client.broadcaster.sendTransform(t)def test_current_cfg(env, robot):    print("Test grasping in current position.")    pose = robot.manip.get_ee_pose(matrix=True)    pos, quat = robot.manip.get_ee_pose(matrix=False)    cfg = robot.manip.solve_ik(pos, quat)    print("Solve IK for current pose:", cfg)    fk_pos, fk_quat = robot.manip.solve_fk(cfg)    fk_pose = posquat2sophus(fk_pos, fk_quat)    _send_predicted_grasp_to_tf(env.grasp_planner, "current_ee_pose", pose)    minimal_error = np.all(np.abs(fk_pose.matrix() - pose) < 1e-4)    print("Minimal error between pose and fk pose:", minimal_error)    print("Config =", cfg)    cfg_manip = (robot.manip._extract_joint_pos(cfg),)    print("Manip cfg =", cfg_manip)    return pose@click.command()@click.option("--visualize-maps", default=False, is_flag=True)@click.option("--reset-nav", default=False, is_flag=True)@click.option("--test-id", default=0, type=int)def run_experiment(visualize_maps=False, test_id=0, reset_nav=False, **kwargs):    config = load_config(visualize=visualize_maps, **kwargs)    rospy.init_node("eval_episode_stretch_objectnav")    env = StretchPickandPlaceEnv(config=config)    env.reset("table", "cup", "chair")    robot = env.get_robot()    if reset_nav:        # Send it back to origin position to make testing a bit easier        robot.nav.navigate_to([0, 0, 0])    # Put it into initial posture    env.robot.move_to_manip_posture()    # do some tests    if test_id == 0:        test_current_cfg(env, robot)        input("---")        # Test discrete actions        action = DiscreteNavigationAction.TURN_RIGHT        env.apply_action(action)        test_current_cfg(env, robot)        input("---")        action = DiscreteNavigationAction.TURN_LEFT        env.apply_action(action)        pose = test_current_cfg(env, robot)    elif test_id == 1:        pose = np.array(            [                [0.23301425, -0.97144842, -0.04463536, -0.00326367],                [-0.97188458, -0.23103087, -0.04544342, -0.44448592],                [0.0338338, 0.05396939, -0.99796923, 0.99206106],                [                    0.0,                    0.0,                    0.0,                    1.0,                ],            ]        )    elif test_id == 2:        # Most recent failing position        pose = np.array(            [                [0.63598766, 0.75559136, 0.15684828, -0.12786708],                [0.70388954, -0.65130729, 0.28344016, -0.57091706],                [0.31632136, -0.06986059, -0.94607626, 1.01114796],                [0.0, 0.0, 0.0, 1.0],            ]        )    else:        raise RuntimeError("Test ID not recognized: " + str(test_id))    # - with theta x/y from vertical = 0.16429382745460722 0.2910    # Debugging    pose1 = env.robot.head.get_pose()    pose2 = env.robot.head.get_pose_in_base_coords()    print("head pose in world coords:")    print(pose1)    print("head pose in base coords:")    print(pose2)    # Move to each step in the grasp plan    env.grasp_planner.try_executing_grasp(pose, wait_for_input=True)if __name__ == "__main__":    run_experiment()