"""This file is a test for inverse kinematics on the stretch robot. It makes sure we can reach and execute different positions, which have been generated by the grasp planner. It's a useful utility for now."""import clickimport numpy as npimport rospyfrom home_robot.agent.hierarchical.pick_and_place_agent import PickAndPlaceAgentfrom home_robot.core.interfaces import DiscreteNavigationAction, HybridActionfrom home_robot.motion.stretch import STRETCH_HOME_Q, STRETCH_PREGRASP_Qfrom home_robot.utils.pose import to_pos_quatfrom home_robot_hw.env.stretch_pick_and_place_env import (    StretchPickandPlaceEnv,    load_config,)def print_action(name, action):    print(f"--- {name} ---")    print("is manipulation?", action.is_manipulation())    print("is navigation?", action.is_navigation())    if action.is_manipulation():        joints, xyt = action.get()        print("action xyt =", xyt)        print("action cfg =", joints)    elif action.is_navigation():        xyt = action.get()        print("action xyt =", xyt)    else:        print("action sym =", action.get())@click.command()@click.option("--reset-nav", default=False, is_flag=True)def main(reset_nav=False, **kwargs):    config = load_config(visualize=False, **kwargs)    rospy.init_node("eval_episode_stretch_objectnav")    env = StretchPickandPlaceEnv(config=config)    obs = env.reset("table", "cup", "chair")    robot = env.get_robot()    if reset_nav:        # Send it back to origin position to make testing a bit easier        robot.nav.navigate_to([0, 0, 0])    print()    print("=" * 40)    print("Testing continuous arm control")    print()    action = HybridAction(robot.model.create_action_from_config(STRETCH_HOME_Q))    print_action("HOME CONFIG", action)    env.apply_action(action)    # Try a movement only action    action = HybridAction(xyt=np.array([0, 0, 0]))    print_action("goto(0,0,0)", action)    env.apply_action(action)    # Try another test    action = HybridAction(        robot.model.create_action(            lift=0.75,            arm=0.15,            defaults=robot.model.create_action_from_config(STRETCH_HOME_Q).joints,        )    )    print_action("lift arm", action)    env.apply_action(action)    pregrasp_q = robot.model.update_look_at_ee(STRETCH_PREGRASP_Q.copy())    pregrasp_cfg = robot.model.create_action_from_config(pregrasp_q).joints    action = HybridAction(        robot.model.create_action(            lift=0.4,            arm=0.1,            pan=-0.5,            defaults=pregrasp_cfg,        )    )    print_action("down and in", action)    env.apply_action(action)    input("Press enter to continue...")    print()    print("=" * 40)    print("Testing discrete actions")    print()    # Test discrete actions    action = HybridAction(DiscreteNavigationAction.TURN_RIGHT)    print_action("turn right", action)    env.apply_action(action)    action = HybridAction(DiscreteNavigationAction.TURN_LEFT)    print_action("turn left", action)    env.apply_action(action)    # TODO: uncomment this to test; it's commented out because it takes a lot of space right now    # action = HybridAction(DiscreteNavigationAction.EXTEND_ARM)    # print_action("extend arm", action)    # env.apply_action(action)    action = HybridAction(DiscreteNavigationAction.MANIPULATION_MODE)    print_action("manip mode", action)    env.apply_action(action)    action = HybridAction(DiscreteNavigationAction.NAVIGATION_MODE)    print_action("navig mode", action)    env.apply_action(action)    input("Press enter to continue...")if __name__ == "__main__":    main()