# Copyright 2021,2022 HalfMarble LLC# Permission is hereby granted, free of charge, to any person obtaining a copy# of this software and associated documentation files (the "Software"), to deal# in the Software without restriction, including without limitation the rights# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell# copies of the Software, and to permit persons to whom the Software is# furnished to do so, subject to the following conditions:# The above copyright notice and this permission notice shall be included in# all copies or substantial portions of the Software.# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN# THE SOFTWARE.from kivy.uix.image import Imagefrom kivy.graphics import Fbo, ClearBuffers, ClearColorclass OffScreenImage(Image):    def __init__(self, client, shader, **kwargs):        super(OffScreenImage, self).__init__(**kwargs)        self._client = client        self._fbo = Fbo(use_parent_projection=False, mipmap=True)        if shader is not None:            self._fbo.shader.fs = shader    def paint(self, size):        if size is not None:            self.size = size        self._fbo.size = self.size        with self._fbo:            ClearColor(0, 0, 0, 0)            ClearBuffers()            if self._client is not None:                self._client.paint(self._fbo, self.size)        self._fbo.draw()        self.texture = self._fbo.texture