from collections import OrderedDictimport torchimport torch.nn as nnimport torch.nn.functional as Fimport torch.utils.checkpoint as checkpointfrom timm.models.layers import DropPath, to_2tuple, trunc_normal_import numpy as npimport sysimport ossys.path.append('./models/backbone/')sys.path.append('../ltr/models/backbone/')from config import get_configimport argparsefrom swin_utils import load_checkpointimport mathdef parse_option():    parser = argparse.ArgumentParser('Swin Transformer training and evaluation script', add_help=False)    parser.add_argument('--cfg', type=str, default='./models/backbone/configs/swinv2/swinv2_tiny_patch4_window8_256.yaml', metavar="FILE", help='path to config file', )    parser.add_argument(        "--opts",        help="Modify config options by adding 'KEY VALUE' pairs. ",        default=None,        nargs='+',    )    # easy config modification    parser.add_argument('--batch-size', type=int, help="batch size for single GPU")    parser.add_argument('--data-path', type=str, help='path to dataset')    parser.add_argument('--zip', action='store_true', help='use zipped dataset instead of folder dataset')    parser.add_argument('--cache-mode', type=str, default='part', choices=['no', 'full', 'part'],                        help='no: no cache, '                             'full: cache all data, '                             'part: sharding the dataset into nonoverlapping pieces and only cache one piece')    parser.add_argument('--resume', type=str, default='./ltr/checkpoints/swinv2_tiny_patch4_window8_256.pth', help='resume from checkpoint')    parser.add_argument('--accumulation-steps', type=int, help="gradient accumulation steps")    parser.add_argument('--use-checkpoint', action='store_true',                        help="whether to use gradient checkpointing to save memory")    parser.add_argument('--amp-opt-level', type=str, default='O1', choices=['O0', 'O1', 'O2'],                        help='mixed precision opt level, if O0, no amp is used')    parser.add_argument('--output', default='output', type=str, metavar='PATH',                        help='root of output folder, the full path is <output>/<model_name>/<tag> (default: output)')    parser.add_argument('--tag', help='tag of experiment')    parser.add_argument('--eval', action='store_true', help='Perform evaluation only')    parser.add_argument('--throughput', action='store_true', help='Test throughput only')    # distributed training    parser.add_argument("--local_rank", type=int, default=0, help='local rank for DistributedDataParallel')    args, unparsed = parser.parse_known_args()    config = get_config(args)    return args, configclass Mlp(nn.Module):    def __init__(self, in_features, hidden_features=None, out_features=None, act_layer=nn.GELU, drop=0.):        super().__init__()        out_features = out_features or in_features        hidden_features = hidden_features or in_features        self.fc1 = nn.Linear(in_features, hidden_features)        self.act = act_layer()        self.fc2 = nn.Linear(hidden_features, out_features)        self.drop = nn.Dropout(drop)    def forward(self, x):        x = self.fc1(x)        x = self.act(x)        x = self.drop(x)        x = self.fc2(x)        x = self.drop(x)        return xdef window_partition(x, window_size):    """    Args:        x: (B, H, W, C)        window_size (int): window size    Returns:        windows: (num_windows*B, window_size, window_size, C)    """    B, H, W, C = x.shape    x = x.view(B, H // window_size, window_size, W // window_size, window_size, C)    windows = x.permute(0, 1, 3, 2, 4, 5).contiguous().view(-1, window_size, window_size, C)    return windowsdef window_reverse(windows, window_size, H, W):    """    Args:        windows: (num_windows*B, window_size, window_size, C)        window_size (int): Window size        H (int): Height of image        W (int): Width of image    Returns:        x: (B, H, W, C)    """    B = int(windows.shape[0] / (H * W / window_size / window_size))    x = windows.view(B, H // window_size, W // window_size, window_size, window_size, -1)    x = x.permute(0, 1, 3, 2, 4, 5).contiguous().view(B, H, W, -1)    return xclass WindowAttention(nn.Module):    r""" Window based multi-head self attention (W-MSA) module with relative position bias.    It supports both of shifted and non-shifted window.    Args:        dim (int): Number of input channels.        window_size (tuple[int]): The height and width of the window.        num_heads (int): Number of attention heads.        qkv_bias (bool, optional):  If True, add a learnable bias to query, key, value. Default: True        attn_drop (float, optional): Dropout ratio of attention weight. Default: 0.0        proj_drop (float, optional): Dropout ratio of output. Default: 0.0        pretrained_window_size (tuple[int]): The height and width of the window in pre-training.    """    def __init__(self, dim, window_size, num_heads, qkv_bias=True, attn_drop=0., proj_drop=0.,                 pretrained_window_size=[0, 0]):        super().__init__()        self.dim = dim        self.window_size = window_size  # Wh, Ww        self.pretrained_window_size = pretrained_window_size        self.num_heads = num_heads        self.logit_scale = nn.Parameter(torch.log(10 * torch.ones((num_heads, 1, 1))), requires_grad=True)        # mlp to generate continuous relative position bias        self.cpb_mlp = nn.Sequential(nn.Linear(2, 512, bias=True),                                     nn.ReLU(inplace=True),                                     nn.Linear(512, num_heads, bias=False))        # get relative_coords_table        relative_coords_h = torch.arange(-(self.window_size[0] - 1), self.window_size[0], dtype=torch.float32)        relative_coords_w = torch.arange(-(self.window_size[1] - 1), self.window_size[1], dtype=torch.float32)        relative_coords_table = torch.stack(            torch.meshgrid([relative_coords_h,                            relative_coords_w])).permute(1, 2, 0).contiguous().unsqueeze(0)  # 1, 2*Wh-1, 2*Ww-1, 2        if pretrained_window_size[0] > 0:            relative_coords_table[:, :, :, 0] /= (pretrained_window_size[0] - 1)            relative_coords_table[:, :, :, 1] /= (pretrained_window_size[1] - 1)        else:            relative_coords_table[:, :, :, 0] /= (self.window_size[0] - 1)            relative_coords_table[:, :, :, 1] /= (self.window_size[1] - 1)        relative_coords_table *= 8  # normalize to -8, 8        relative_coords_table = torch.sign(relative_coords_table) * torch.log2(            torch.abs(relative_coords_table) + 1.0) / np.log2(8)        self.register_buffer("relative_coords_table", relative_coords_table)        # get pair-wise relative position index for each token inside the window        coords_h = torch.arange(self.window_size[0])        coords_w = torch.arange(self.window_size[1])        coords = torch.stack(torch.meshgrid([coords_h, coords_w]))  # 2, Wh, Ww        coords_flatten = torch.flatten(coords, 1)  # 2, Wh*Ww        relative_coords = coords_flatten[:, :, None] - coords_flatten[:, None, :]  # 2, Wh*Ww, Wh*Ww        relative_coords = relative_coords.permute(1, 2, 0).contiguous()  # Wh*Ww, Wh*Ww, 2        relative_coords[:, :, 0] += self.window_size[0] - 1  # shift to start from 0        relative_coords[:, :, 1] += self.window_size[1] - 1        relative_coords[:, :, 0] *= 2 * self.window_size[1] - 1        relative_position_index = relative_coords.sum(-1)  # Wh*Ww, Wh*Ww        self.register_buffer("relative_position_index", relative_position_index)        self.qkv = nn.Linear(dim, dim * 3, bias=False)        if qkv_bias:            self.q_bias = nn.Parameter(torch.zeros(dim))            self.v_bias = nn.Parameter(torch.zeros(dim))        else:            self.q_bias = None            self.v_bias = None        self.attn_drop = nn.Dropout(attn_drop)        self.proj = nn.Linear(dim, dim)        self.proj_drop = nn.Dropout(proj_drop)        self.softmax = nn.Softmax(dim=-1)    def forward(self, x, mask=None):        """        Args:            x: input features with shape of (num_windows*B, N, C)            mask: (0/-inf) mask with shape of (num_windows, Wh*Ww, Wh*Ww) or None        """        B_, N, C = x.shape        qkv_bias = None        if self.q_bias is not None:            qkv_bias = torch.cat((self.q_bias, torch.zeros_like(self.v_bias, requires_grad=False), self.v_bias))        qkv = F.linear(input=x, weight=self.qkv.weight, bias=qkv_bias)        qkv = qkv.reshape(B_, N, 3, self.num_heads, -1).permute(2, 0, 3, 1, 4)        q, k, v = qkv[0], qkv[1], qkv[2]  # make torchscript happy (cannot use tensor as tuple)        # cosine attention        attn = (F.normalize(q, dim=-1) @ F.normalize(k, dim=-1).transpose(-2, -1))        logit_scale = torch.clamp(self.logit_scale, max=torch.log(torch.tensor(1. / 0.01))).exp()        attn = attn * logit_scale        relative_position_bias_table = self.cpb_mlp(self.relative_coords_table).view(-1, self.num_heads)        relative_position_bias = relative_position_bias_table[self.relative_position_index.view(-1)].view(            self.window_size[0] * self.window_size[1], self.window_size[0] * self.window_size[1], -1)  # Wh*Ww,Wh*Ww,nH        relative_position_bias = relative_position_bias.permute(2, 0, 1).contiguous()  # nH, Wh*Ww, Wh*Ww        relative_position_bias = 16 * torch.sigmoid(relative_position_bias)        attn = attn + relative_position_bias.unsqueeze(0)        if mask is not None:            nW = mask.shape[0]            attn = attn.view(B_ // nW, nW, self.num_heads, N, N) + mask.unsqueeze(1).unsqueeze(0)            attn = attn.view(-1, self.num_heads, N, N)            attn = self.softmax(attn)        else:            attn = self.softmax(attn)        attn = self.attn_drop(attn)        x = (attn @ v).transpose(1, 2).reshape(B_, N, C)        x = self.proj(x)        x = self.proj_drop(x)        return x    def extra_repr(self) -> str:        return f'dim={self.dim}, window_size={self.window_size}, ' \               f'pretrained_window_size={self.pretrained_window_size}, num_heads={self.num_heads}'    def flops(self, N):        # calculate flops for 1 window with token length of N        flops = 0        # qkv = self.qkv(x)        flops += N * self.dim * 3 * self.dim        # attn = (q @ k.transpose(-2, -1))        flops += self.num_heads * N * (self.dim // self.num_heads) * N        #  x = (attn @ v)        flops += self.num_heads * N * N * (self.dim // self.num_heads)        # x = self.proj(x)        flops += N * self.dim * self.dim        return flopsclass SwinTransformerBlock(nn.Module):    r""" Swin Transformer Block.    Args:        dim (int): Number of input channels.        input_resolution (tuple[int]): Input resulotion.        num_heads (int): Number of attention heads.        window_size (int): Window size.        shift_size (int): Shift size for SW-MSA.        mlp_ratio (float): Ratio of mlp hidden dim to embedding dim.        qkv_bias (bool, optional): If True, add a learnable bias to query, key, value. Default: True        drop (float, optional): Dropout rate. Default: 0.0        attn_drop (float, optional): Attention dropout rate. Default: 0.0        drop_path (float, optional): Stochastic depth rate. Default: 0.0        act_layer (nn.Module, optional): Activation layer. Default: nn.GELU        norm_layer (nn.Module, optional): Normalization layer.  Default: nn.LayerNorm        pretrained_window_size (int): Window size in pre-training.    """    def __init__(self, dim, input_resolution, num_heads, window_size=7, shift_size=0,                 mlp_ratio=4., qkv_bias=True, drop=0., attn_drop=0., drop_path=0.,                 act_layer=nn.GELU, norm_layer=nn.LayerNorm, pretrained_window_size=0):        super().__init__()        self.dim = dim        self.input_resolution = input_resolution        self.num_heads = num_heads        self.window_size = window_size        self.shift_size = shift_size        self.mlp_ratio = mlp_ratio        if min(self.input_resolution) <= self.window_size:            # if window size is larger than input resolution, we don't partition windows            self.shift_size = 0            self.window_size = min(self.input_resolution)        assert 0 <= self.shift_size < self.window_size, "shift_size must in 0-window_size"        self.norm1 = norm_layer(dim)        self.attn = WindowAttention(            dim, window_size=to_2tuple(self.window_size), num_heads=num_heads,            qkv_bias=qkv_bias, attn_drop=attn_drop, proj_drop=drop,            pretrained_window_size=to_2tuple(pretrained_window_size))        self.drop_path = DropPath(drop_path) if drop_path > 0. else nn.Identity()        self.norm2 = norm_layer(dim)        mlp_hidden_dim = int(dim * mlp_ratio)        self.mlp = Mlp(in_features=dim, hidden_features=mlp_hidden_dim, act_layer=act_layer, drop=drop)        if self.shift_size > 0:            # calculate attention mask for SW-MSA            H, W = self.input_resolution            img_mask = torch.zeros((1, H, W, 1))  # 1 H W 1            h_slices = (slice(0, -self.window_size),                        slice(-self.window_size, -self.shift_size),                        slice(-self.shift_size, None))            w_slices = (slice(0, -self.window_size),                        slice(-self.window_size, -self.shift_size),                        slice(-self.shift_size, None))            cnt = 0            for h in h_slices:                for w in w_slices:                    img_mask[:, h, w, :] = cnt                    cnt += 1            mask_windows = window_partition(img_mask, self.window_size)  # nW, window_size, window_size, 1            mask_windows = mask_windows.view(-1, self.window_size * self.window_size)            attn_mask = mask_windows.unsqueeze(1) - mask_windows.unsqueeze(2)            attn_mask = attn_mask.masked_fill(attn_mask != 0, float(-100.0)).masked_fill(attn_mask == 0, float(0.0))        else:            attn_mask = None        self.register_buffer("attn_mask", attn_mask)        self.input_resolution_temp = (int(self.input_resolution[0]/2), int(self.input_resolution[1]/2))        if self.shift_size > 0:            # calculate attention mask for SW-MSA            H, W = self.input_resolution_temp            img_mask = torch.zeros((1, H, W, 1))  # 1 H W 1            h_slices = (slice(0, -self.window_size),                        slice(-self.window_size, -self.shift_size),                        slice(-self.shift_size, None))            w_slices = (slice(0, -self.window_size),                        slice(-self.window_size, -self.shift_size),                        slice(-self.shift_size, None))            cnt = 0            for h in h_slices:                for w in w_slices:                    img_mask[:, h, w, :] = cnt                    cnt += 1            mask_windows = window_partition(img_mask, self.window_size)  # nW, window_size, window_size, 1            mask_windows = mask_windows.view(-1, self.window_size * self.window_size)            attn_mask = mask_windows.unsqueeze(1) - mask_windows.unsqueeze(2)            attn_mask_temp = attn_mask.masked_fill(attn_mask != 0, float(-100.0)).masked_fill(attn_mask == 0, float(0.0))        else:            attn_mask_temp = None        self.register_buffer("attn_mask_temp", attn_mask_temp)    def forward(self, x):        H, W = self.input_resolution        H_t, W_t = self.input_resolution_temp        # print('shape of X:{}'.format(x.shape))        B, L, C = x.shape        # assert L == H * W, "input feature has wrong size"        if L == H * W:            Temp=False        elif L == H_t * W_t:            Temp=True            H = H_t            W = W_t        else:            print('Input shape Error: L:{}, input resolution:{}, temp resolution:{}, x resolution:{}'.format(L, self.input_resolution, self.input_resolution_temp, L))            assert(0==1)        shortcut = x        x = x.view(B, H, W, C)        # cyclic shift        if self.shift_size > 0:            shifted_x = torch.roll(x, shifts=(-self.shift_size, -self.shift_size), dims=(1, 2))        else:            shifted_x = x        # partition windows        x_windows = window_partition(shifted_x, self.window_size)  # nW*B, window_size, window_size, C        x_windows = x_windows.view(-1, self.window_size * self.window_size, C)  # nW*B, window_size*window_size, C        # W-MSA/SW-MSA        if Temp:            attn_windows = self.attn(x_windows, mask=self.attn_mask_temp)  # nW*B, window_size*window_size, C                else:            attn_windows = self.attn(x_windows, mask=self.attn_mask)  # nW*B, window_size*window_size, C        # merge windows        attn_windows = attn_windows.view(-1, self.window_size, self.window_size, C)        shifted_x = window_reverse(attn_windows, self.window_size, H, W)  # B H' W' C        # reverse cyclic shift        if self.shift_size > 0:            x = torch.roll(shifted_x, shifts=(self.shift_size, self.shift_size), dims=(1, 2))        else:            x = shifted_x        x = x.view(B, H * W, C)        x = shortcut + self.drop_path(self.norm1(x))        # FFN        x = x + self.drop_path(self.norm2(self.mlp(x)))        return x    def extra_repr(self) -> str:        return f"dim={self.dim}, input_resolution={self.input_resolution}, num_heads={self.num_heads}, " \               f"window_size={self.window_size}, shift_size={self.shift_size}, mlp_ratio={self.mlp_ratio}"    def flops(self):        flops = 0        H, W = self.input_resolution        # norm1        flops += self.dim * H * W        # W-MSA/SW-MSA        nW = H * W / self.window_size / self.window_size        flops += nW * self.attn.flops(self.window_size * self.window_size)        # mlp        flops += 2 * H * W * self.dim * self.dim * self.mlp_ratio        # norm2        flops += self.dim * H * W        return flopsclass PatchMerging(nn.Module):    r""" Patch Merging Layer.    Args:        input_resolution (tuple[int]): Resolution of input feature.        dim (int): Number of input channels.        norm_layer (nn.Module, optional): Normalization layer.  Default: nn.LayerNorm    """    def __init__(self, input_resolution, dim, norm_layer=nn.LayerNorm):        super().__init__()        self.input_resolution = input_resolution        self.dim = dim        self.reduction = nn.Linear(4 * dim, 2 * dim, bias=False)        # self.reduction2 = nn.Linear(dim, 2 * dim, bias=False)        self.norm = norm_layer(2 * dim)        self.input_resolution_temp = (int(self.input_resolution[0]/2), int(self.input_resolution[1]/2))    def forward(self, x):        """        x: B, H*W, C        """        H, W = self.input_resolution        H_t, W_t = self.input_resolution_temp        B, L, C = x.shape        if L!= H*W:            H, W = H_t, W_t        # assert L == H * W, "input feature has wrong size"        assert H % 2 == 0 and W % 2 == 0, f"x size ({H}*{W}) are not even."        x = x.view(B, H, W, C)        x0 = x[:, 0::2, 0::2, :]  # B H/2 W/2 C        x1 = x[:, 1::2, 0::2, :]  # B H/2 W/2 C        x2 = x[:, 0::2, 1::2, :]  # B H/2 W/2 C        x3 = x[:, 1::2, 1::2, :]  # B H/2 W/2 C        x = torch.cat([x0, x1, x2, x3], -1)  # B H/2 W/2 4*C        x = x.view(B, -1, 4 * C)  # B H/2*W/2 4*C        x = self.reduction(x)        # if C == 96:        #     x = x.view(B, H, W, C)        #     x0 = x[:, 0::2, 0::2, :]  # B H/2 W/2 C        #     x1 = x[:, 1::2, 0::2, :]  # B H/2 W/2 C        #     x2 = x[:, 0::2, 1::2, :]  # B H/2 W/2 C        #     x3 = x[:, 1::2, 1::2, :]  # B H/2 W/2 C        #     x = torch.cat([x0, x1, x2, x3], -1)  # B H/2 W/2 4*C        #     x = x.view(B, -1, 4 * C)  # B H/2*W/2 4*C        #     x = self.reduction(x)        # else:        #     # print('shape of self.reduction.weight:{}'.format(self.reduction.weight.shape))        #     x = nn.functional.linear(x, self.reduction.weight.reshape([ 2*self.dim, self.dim, 4]).mean(2))        x = self.norm(x)        return x    def extra_repr(self) -> str:        return f"input_resolution={self.input_resolution}, dim={self.dim}"    def flops(self):        H, W = self.input_resolution        flops = (H // 2) * (W // 2) * 4 * self.dim * 2 * self.dim        flops += H * W * self.dim // 2        return flopsclass BasicLayer(nn.Module):    """ A basic Swin Transformer layer for one stage.    Args:        dim (int): Number of input channels.        input_resolution (tuple[int]): Input resolution.        depth (int): Number of blocks.        num_heads (int): Number of attention heads.        window_size (int): Local window size.        mlp_ratio (float): Ratio of mlp hidden dim to embedding dim.        qkv_bias (bool, optional): If True, add a learnable bias to query, key, value. Default: True        drop (float, optional): Dropout rate. Default: 0.0        attn_drop (float, optional): Attention dropout rate. Default: 0.0        drop_path (float | tuple[float], optional): Stochastic depth rate. Default: 0.0        norm_layer (nn.Module, optional): Normalization layer. Default: nn.LayerNorm        downsample (nn.Module | None, optional): Downsample layer at the end of the layer. Default: None        use_checkpoint (bool): Whether to use checkpointing to save memory. Default: False.        pretrained_window_size (int): Local window size in pre-training.    """    def __init__(self, dim, input_resolution, depth, num_heads, window_size,                 mlp_ratio=4., qkv_bias=True, drop=0., attn_drop=0.,                 drop_path=0., norm_layer=nn.LayerNorm, downsample=None, use_checkpoint=False,                 pretrained_window_size=0):        super().__init__()        self.dim = dim        self.input_resolution = input_resolution        self.depth = depth        self.use_checkpoint = use_checkpoint        # build blocks        self.blocks = nn.ModuleList([            SwinTransformerBlock(dim=dim, input_resolution=input_resolution,                                 num_heads=num_heads, window_size=window_size,                                 shift_size=0 if (i % 2 == 0) else window_size // 2,                                 mlp_ratio=mlp_ratio,                                 qkv_bias=qkv_bias,                                 drop=drop, attn_drop=attn_drop,                                 drop_path=drop_path[i] if isinstance(drop_path, list) else drop_path,                                 norm_layer=norm_layer,                                 pretrained_window_size=pretrained_window_size)            for i in range(depth)])        # patch merging layer        if downsample is not None:            self.downsample = downsample(input_resolution, dim=dim, norm_layer=norm_layer)        else:            self.downsample = None    def forward(self, x):        for blk in self.blocks:            if self.use_checkpoint:                x = checkpoint.checkpoint(blk, x)            else:                x = blk(x)        if self.downsample is not None:            x_ = self.downsample(x)            return x, x_        else:            return x, x    def extra_repr(self) -> str:        return f"dim={self.dim}, input_resolution={self.input_resolution}, depth={self.depth}"    def flops(self):        flops = 0        for blk in self.blocks:            flops += blk.flops()        if self.downsample is not None:            flops += self.downsample.flops()        return flops    def _init_respostnorm(self):        for blk in self.blocks:            nn.init.constant_(blk.norm1.bias, 0)            nn.init.constant_(blk.norm1.weight, 0)            nn.init.constant_(blk.norm2.bias, 0)            nn.init.constant_(blk.norm2.weight, 0)class PatchEmbed(nn.Module):    r""" Image to Patch Embedding    Args:        img_size (int): Image size.  Default: 224.        patch_size (int): Patch token size. Default: 4.        in_chans (int): Number of input image channels. Default: 3.        embed_dim (int): Number of linear projection output channels. Default: 96.        norm_layer (nn.Module, optional): Normalization layer. Default: None    """    def __init__(self, img_size=224, patch_size=4, in_chans=3, embed_dim=96, norm_layer=None):        super().__init__()        img_size = to_2tuple(img_size)        patch_size = to_2tuple(patch_size)        patches_resolution = [img_size[0] // patch_size[0], img_size[1] // patch_size[1]]        self.img_size = img_size        self.patch_size = patch_size        self.patches_resolution = patches_resolution        self.num_patches = patches_resolution[0] * patches_resolution[1]        self.in_chans = in_chans        self.embed_dim = embed_dim        self.proj = nn.Conv2d(in_chans, embed_dim, kernel_size=patch_size, stride=patch_size)        if norm_layer is not None:            self.norm = norm_layer(embed_dim)        else:            self.norm = None    def forward(self, x):        B, C, H, W = x.shape        # FIXME look at relaxing size constraints        assert (H == self.img_size[0] and W == self.img_size[1]) or (H == self.img_size[0]//2 and W == self.img_size[1]//2), \            f"Input image size ({H}*{W}) doesn't match model ({self.img_size[0]}*{self.img_size[1]})."        x = self.proj(x).flatten(2).transpose(1, 2)  # B Ph*Pw C        if self.norm is not None:            x = self.norm(x)        return x    def flops(self):        Ho, Wo = self.patches_resolution        flops = Ho * Wo * self.embed_dim * self.in_chans * (self.patch_size[0] * self.patch_size[1])        if self.norm is not None:            flops += Ho * Wo * self.embed_dim        return flopsclass SwinTransformerV2(nn.Module):    r""" Swin Transformer        A PyTorch impl of : `Swin Transformer: Hierarchical Vision Transformer using Shifted Windows`  -          https://arxiv.org/pdf/2103.14030    Args:        img_size (int | tuple(int)): Input image size. Default 224        patch_size (int | tuple(int)): Patch size. Default: 4        in_chans (int): Number of input image channels. Default: 3        num_classes (int): Number of classes for classification head. Default: 1000        embed_dim (int): Patch embedding dimension. Default: 96        depths (tuple(int)): Depth of each Swin Transformer layer.        num_heads (tuple(int)): Number of attention heads in different layers.        window_size (int): Window size. Default: 7        mlp_ratio (float): Ratio of mlp hidden dim to embedding dim. Default: 4        qkv_bias (bool): If True, add a learnable bias to query, key, value. Default: True        drop_rate (float): Dropout rate. Default: 0        attn_drop_rate (float): Attention dropout rate. Default: 0        drop_path_rate (float): Stochastic depth rate. Default: 0.1        norm_layer (nn.Module): Normalization layer. Default: nn.LayerNorm.        ape (bool): If True, add absolute position embedding to the patch embedding. Default: False        patch_norm (bool): If True, add normalization after patch embedding. Default: True        use_checkpoint (bool): Whether to use checkpointing to save memory. Default: False        pretrained_window_sizes (tuple(int)): Pretrained window sizes of each layer.    """    def __init__(self, img_size=224, patch_size=4, in_chans=3, num_classes=1000,                 embed_dim=96, depths=[2, 2, 6, 2], num_heads=[3, 6, 12, 24],                 window_size=7, mlp_ratio=4., qkv_bias=True,                 drop_rate=0., attn_drop_rate=0., drop_path_rate=0.1,                 norm_layer=nn.LayerNorm, ape=False, patch_norm=True,                 use_checkpoint=False, pretrained_window_sizes=[0, 0, 0, 0], **kwargs):        super().__init__()        self.num_classes = num_classes        self.num_layers = len(depths)        self.embed_dim = embed_dim        self.ape = ape        self.patch_norm = patch_norm        self.num_features = int(embed_dim * 2 ** (self.num_layers - 1))        self.mlp_ratio = mlp_ratio        # split image into non-overlapping patches        self.patch_embed = PatchEmbed(            img_size=img_size, patch_size=patch_size, in_chans=in_chans, embed_dim=embed_dim,            norm_layer=norm_layer if self.patch_norm else None)        num_patches = self.patch_embed.num_patches        patches_resolution = self.patch_embed.patches_resolution        self.patches_resolution = patches_resolution        # absolute position embedding        if self.ape:            self.absolute_pos_embed = nn.Parameter(torch.zeros(1, num_patches, embed_dim))            trunc_normal_(self.absolute_pos_embed, std=.02)        self.pos_drop = nn.Dropout(p=drop_rate)        # stochastic depth        dpr = [x.item() for x in torch.linspace(0, drop_path_rate, sum(depths))]  # stochastic depth decay rule        # build layers        self.layers = nn.ModuleList()        for i_layer in range(self.num_layers):            layer = BasicLayer(dim=int(embed_dim * 2 ** i_layer),                               input_resolution=(patches_resolution[0] // (2 ** i_layer),                                                 patches_resolution[1] // (2 ** i_layer)),                               depth=depths[i_layer],                               num_heads=num_heads[i_layer],                               window_size=window_size,                               mlp_ratio=self.mlp_ratio,                               qkv_bias=qkv_bias,                               drop=drop_rate, attn_drop=attn_drop_rate,                               drop_path=dpr[sum(depths[:i_layer]):sum(depths[:i_layer + 1])],                               norm_layer=norm_layer,                               downsample=PatchMerging if (i_layer < self.num_layers - 1) else None,                               use_checkpoint=use_checkpoint,                               pretrained_window_size=pretrained_window_sizes[i_layer])            self.layers.append(layer)        self.norm = norm_layer(self.num_features)        self.avgpool = nn.AdaptiveAvgPool1d(1)        self.head = nn.Linear(self.num_features, num_classes) if num_classes > 0 else nn.Identity()        self.apply(self._init_weights)        for bly in self.layers:            bly._init_respostnorm()    def _init_weights(self, m):        if isinstance(m, nn.Linear):            trunc_normal_(m.weight, std=.02)            if isinstance(m, nn.Linear) and m.bias is not None:                nn.init.constant_(m.bias, 0)        elif isinstance(m, nn.LayerNorm):            nn.init.constant_(m.bias, 0)            nn.init.constant_(m.weight, 1.0)    @torch.jit.ignore    def no_weight_decay(self):        return {'absolute_pos_embed'}    @torch.jit.ignore    def no_weight_decay_keywords(self):        return {"cpb_mlp", "logit_scale", 'relative_position_bias_table'}    def forward_features(self, x):        x = self.patch_embed(x)        if self.ape:            x = x + self.absolute_pos_embed        x = self.pos_drop(x)        for layer in self.layers:            x = layer(x)        x = self.norm(x)  # B L C        x = self.avgpool(x.transpose(1, 2))  # B C 1        x = torch.flatten(x, 1)        return x    def mask_output(self, x, Emb_x, ratio):        # x [2, 3, 256, 256]        # Emb_x [2, 100, 4096]        # print('shape of x:{}, Emb_x:{}'.format(x.shape, Emb_x.shape))        B, C, H, W =x.shape        # H, W = int(math.sqrt(L)), int(math.sqrt(L))        # x = x.reshape([B, H, W, C]).permute([0, 3, 1, 2])        patch_num = int(1/ratio)        patch_size = int(H * ratio)        flag = torch.rand([B,1,1,patch_num,patch_num],device = x.device) > 0.4        flag = flag.float()        flag = flag.repeat([1,patch_size, patch_size, 1, 1])        flag = flag.permute([0,3,1,4,2]).reshape(B,H,W)        flag = flag[:,None,:,:].repeat(1,C,1,1)        flag_n = 1- flag        flag_n = flag_n * x.mean([2,3],keepdim=True)        x = x*flag + flag_n        x1 = self.patch_embed(x)                        B, L1, C =x1.shape        # B, C, L =Emb_x.shape        H, W = int(math.sqrt(L1)), int(math.sqrt(L1))        Emb_x = Emb_x.reshape([B, C +4, H, W])                patch_size2 = int(H * ratio)        flag = torch.rand([B,1,1,patch_num,patch_num],device = x.device) > 0.3        flag = flag.float()        flag = flag.repeat([1,patch_size2, patch_size2, 1, 1])        flag = flag.permute([0,3,1,4,2]).reshape(B,H,W)        flag = flag[:,None,:,:].repeat(1,C,1,1)        if self.patch_embed.norm is not None:            Embx = Emb_x.permute([0,2,3,1])[:,:,:,4:]            # print('shape of Embx:{}'.format(Embx.shape))            Emb_x = self.patch_embed.norm(Embx).permute([0,3,1,2])        # Emb_x1 = Emb_x[:,4:,:]        # Emb_x = Emb_x1.reshape([B, C-4, H, W])        # Emb_x =         # Emb_x = self.bn1(Emb_x)        # Emb_x = self.relu(Emb_x)                Emb_x = Emb_x * flag        return x1, Emb_x            def train_forward(self, x, output_layers=None, Emb_x = None, ratio = 0.25):        """ Forward pass with input x. The output_layers specify the feature blocks which must be returned """        outputs = OrderedDict()        Emb_x_out = []        x_out = []        Emb_x_out.append(Emb_x.clone())        x1, Emb_x = self.mask_output(x, Emb_x, ratio)        B, C, H,W =Emb_x.shape        Emb_x = Emb_x.reshape([B, C, H*W]).permute([0, 2, 1])        flag = torch.rand(B,device = x1.device) > 0.1        flag = flag.float()[:,None,None]        flag2 = torch.rand(B,device = x1.device) > 0.1        flag2 = flag2.float()[:,None,None]        flag2 = 1-flag + flag*flag2        Emb_x = (Emb_x*flag + x1*flag2) / (flag + flag2 + 1e-3)        _, Emb_x1 = self.layers[0](Emb_x)        Emb_x_out.append(Emb_x1)        _, Emb_x2 = self.layers[1](Emb_x1)        Emb_x_out.append(Emb_x2)        Emb_x3, _ = self.layers[2](Emb_x2)        B, L, C = Emb_x3.shape        Emb_x3 = Emb_x3.reshape([B, int(math.sqrt(L)), int(math.sqrt(L)), C]).permute([0, 3, 1, 2])        Emb_x_out.append(Emb_x3)        outputs['layer3'] = Emb_x3        return outputs, Emb_x_out, Emb_x_out    def forward(self, x, output_layers=None, Emb_x = None):        """ Forward pass with input x. The output_layers specify the feature blocks which must be returned """        outputs = OrderedDict()        x1 = self.patch_embed(x)        Emb_x_out = []        x_out = []        B, C, L = Emb_x.shape        # Emb_x_out.append(Emb_x.clone().reshape([B, C, int(math.sqrt(L)), int(math.sqrt(L))]))        Emb_x_out.append(Emb_x.clone())        Emb_x = Emb_x[:,4:,:].permute([0,2,1])                if self.patch_embed.norm is not None:            Emb_x = self.patch_embed.norm(Emb_x)                Emb_x = (Emb_x + x1) / 2        _, Emb_x1 = self.layers[0](Emb_x)        Emb_x_out.append(Emb_x1)        _, Emb_x2 = self.layers[1](Emb_x1)        Emb_x_out.append(Emb_x2)        Emb_x3, _ = self.layers[2](Emb_x2)        B, L, C = Emb_x3.shape        Emb_x3 = Emb_x3.reshape([B, int(math.sqrt(L)), int(math.sqrt(L)), C]).permute([0, 3, 1, 2])        Emb_x_out.append(Emb_x3)        outputs['layer3'] = Emb_x3        return outputs, Emb_x_out, Emb_x_out        raise ValueError('output_layer is wrong.')    def flops(self):        flops = 0        flops += self.patch_embed.flops()        for i, layer in enumerate(self.layers):            flops += layer.flops()        flops += self.num_features * self.patches_resolution[0] * self.patches_resolution[1] // (2 ** self.num_layers)        flops += self.num_features * self.num_classes        return flopsdef SwinV2T(is_pretrain=False):    _,config = parse_option()    model_type = config.MODEL.TYPE    if config.FUSED_LAYERNORM:        try:            import apex as amp            layernorm = amp.normalization.FusedLayerNorm        except:            layernorm = None            print("To use FusedLayerNorm, please install apex.")    else:        import torch.nn as nn        layernorm = nn.LayerNorm    # if model_type == 'swin':    #     model = SwinTransformer(img_size=config.DATA.IMG_SIZE,    #                             patch_size=config.MODEL.SWIN.PATCH_SIZE,    #                             in_chans=config.MODEL.SWIN.IN_CHANS,    #                             num_classes=config.MODEL.NUM_CLASSES,    #                             embed_dim=config.MODEL.SWIN.EMBED_DIM,    #                             depths=config.MODEL.SWIN.DEPTHS,    #                             num_heads=config.MODEL.SWIN.NUM_HEADS,    #                             window_size=config.MODEL.SWIN.WINDOW_SIZE,    #                             mlp_ratio=config.MODEL.SWIN.MLP_RATIO,    #                             qkv_bias=config.MODEL.SWIN.QKV_BIAS,    #                             qk_scale=config.MODEL.SWIN.QK_SCALE,    #                             drop_rate=config.MODEL.DROP_RATE,    #                             drop_path_rate=config.MODEL.DROP_PATH_RATE,    #                             ape=config.MODEL.SWIN.APE,    #                             norm_layer=layernorm,    #                             patch_norm=config.MODEL.SWIN.PATCH_NORM,    #                             use_checkpoint=config.TRAIN.USE_CHECKPOINT,    #                             fused_window_process=config.FUSED_WINDOW_PROCESS)    if model_type == 'swinv2':        model = SwinTransformerV2(img_size=config.DATA.IMG_SIZE,                                  patch_size=config.MODEL.SWINV2.PATCH_SIZE,                                  in_chans=config.MODEL.SWINV2.IN_CHANS,                                  num_classes=config.MODEL.NUM_CLASSES,                                  embed_dim=config.MODEL.SWINV2.EMBED_DIM,                                  depths=config.MODEL.SWINV2.DEPTHS,                                  num_heads=config.MODEL.SWINV2.NUM_HEADS,                                  window_size=config.MODEL.SWINV2.WINDOW_SIZE,                                  mlp_ratio=config.MODEL.SWINV2.MLP_RATIO,                                  qkv_bias=config.MODEL.SWINV2.QKV_BIAS,                                  drop_rate=config.MODEL.DROP_RATE,                                  drop_path_rate=config.MODEL.DROP_PATH_RATE,                                  ape=config.MODEL.SWINV2.APE,                                  patch_norm=config.MODEL.SWINV2.PATCH_NORM,                                  use_checkpoint=config.TRAIN.USE_CHECKPOINT,                                  pretrained_window_sizes=config.MODEL.SWINV2.PRETRAINED_WINDOW_SIZES)    else:        raise NotImplementedError(f"Unkown model: {model_type}")    model = load_checkpoint(config, model)    return model