def make_divisible(value, divisor, min_value=None, min_ratio=0.9):    """Make divisible function.    This function rounds the channel number to the nearest value that can be    divisible by the divisor. It is taken from the original tf repo. It ensures    that all layers have a channel number that is divisible by divisor. It can    be seen here: https://github.com/tensorflow/models/blob/master/research/slim/nets/mobilenet/mobilenet.py  # noqa    Args:        value (int): The original channel number.        divisor (int): The divisor to fully divide the channel number.        min_value (int): The minimum value of the output channel.            Default: None, means that the minimum value equal to the divisor.        min_ratio (float): The minimum ratio of the rounded channel number to            the original channel number. Default: 0.9.    Returns:        int: The modified output channel number.    """    if min_value is None:        min_value = divisor    new_value = max(min_value, int(value + divisor / 2) // divisor * divisor)    # Make sure that round down does not go down by more than (1-min_ratio).    if new_value < min_ratio * value:        new_value += divisor    return new_value