import os.path as ospimport warningsimport torch.distributed as distfrom mmcv.runner import DistEvalHook as _DistEvalHookfrom mmcv.runner import EvalHook as _EvalHookfrom torch.nn.modules.batchnorm import _BatchNormclass EvalHook(_EvalHook):    """Single GPU EvalHook, with efficient test support.    Args:        by_epoch (bool): Determine perform evaluation by epoch or by iteration.            If set to True, it will perform by epoch. Otherwise, by iteration.            Default: False.        efficient_test (bool): Whether save the results as local numpy files to            save CPU memory during evaluation. Default: False.    Returns:        list: The prediction results.    """    greater_keys = ['mIoU', 'mAcc', 'aAcc']    def __init__(self,                 *args,                 by_epoch=False,                 efficient_test=False,                 **kwargs):        super().__init__(*args, by_epoch=by_epoch, **kwargs)        self.efficent_test = efficient_test        if efficient_test:            warnings.warn(                'DeprecationWarning: ``efficient_test`` for evaluation hook '                'is deprecated, the evaluation hook is CPU memory friendly '                'with ``pre_eval=True`` as argument for ``single_gpu_test()`` '                'function')    def _do_evaluate(self, runner):        """perform evaluation and save ckpt."""        if not self._should_evaluate(runner):            return        from mmseg.apis import single_gpu_test        results = single_gpu_test(            runner.model,             self.dataloader,             show=False,	        efficient_test=self.efficient_test)        runner.log_buffer.output['eval_iter_num'] = len(self.dataloader)        key_score = self.evaluate(runner, results)        if self.save_best:            self._save_ckpt(runner, key_score)class DistEvalHook(_DistEvalHook):    """Distributed EvalHook, with efficient test support.    Args:        by_epoch (bool): Determine perform evaluation by epoch or by iteration.            If set to True, it will perform by epoch. Otherwise, by iteration.            Default: False.        efficient_test (bool): Whether save the results as local numpy files to            save CPU memory during evaluation. Default: False.        pre_eval (bool): Whether to use progressive mode to evaluate model.            Default: False.    Returns:        list: The prediction results.    """    greater_keys = ['mIoU', 'mAcc', 'aAcc']    def __init__(self,                 *args,                 by_epoch=False,                 efficient_test=False,                 **kwargs):        super().__init__(*args, by_epoch=by_epoch, **kwargs)        self.efficient_test = efficient_test        if efficient_test:            warnings.warn(                'DeprecationWarning: ``efficient_test`` for evaluation hook '                'is deprecated, the evaluation hook is CPU memory friendly '                'with ``pre_eval=True`` as argument for ``multi_gpu_test()`` '                'function')    def _do_evaluate(self, runner):        """perform evaluation and save ckpt."""        # Synchronization of BatchNorm's buffer (running_mean        # and running_var) is not supported in the DDP of pytorch,        # which may cause the inconsistent performance of models in        # different ranks, so we broadcast BatchNorm's buffers        # of rank 0 to other ranks to avoid this.        if self.broadcast_bn_buffer:            model = runner.model            for name, module in model.named_modules():                if isinstance(module,                              _BatchNorm) and module.track_running_stats:                    dist.broadcast(module.running_var, 0)                    dist.broadcast(module.running_mean, 0)        if not self._should_evaluate(runner):            return        tmpdir = self.tmpdir        if tmpdir is None:            tmpdir = osp.join(runner.work_dir, '.eval_hook')                from mmseg.apis import multi_gpu_test        results = multi_gpu_test(            runner.model,            self.dataloader,            tmpdir=tmpdir,            gpu_collect=self.gpu_collect,	        efficient_test=self.efficient_test)        if runner.rank == 0:            print('\n')            runner.log_buffer.output['eval_iter_num'] = len(self.dataloader)            key_score = self.evaluate(runner, results)            if self.save_best:                self._save_ckpt(runner, key_score)