import os.path as ospimport tempfileimport mmcvimport numpy as npimport torchfrom mmcv.engine import collect_results_cpu, collect_results_gpufrom mmcv.image import tensor2imgsfrom mmcv.runner import get_dist_infodef np2tmp(array, temp_file_name=None, tmpdir=None):    if temp_file_name is None:        temp_file_name = tempfile.NamedTemporaryFile(            suffix='.npy', delete=False, dir=tmpdir).name    np.save(temp_file_name, array)    return temp_file_namedef single_gpu_test(model,                    data_loader,                    show=False,                    out_dir=None,                    efficient_test=False,                    opacity=0.5):    model.eval()    results = []    dataset = data_loader.dataset    prog_bar = mmcv.ProgressBar(len(dataset))    if efficient_test:        mmcv.mkdir_or_exist('.efficient_test')    for i, data in enumerate(data_loader):        with torch.no_grad():            result = model(return_loss=False, **data)        if show or out_dir:            img_tensor = data['img'][0]            img_metas = data['img_metas'][0].data[0]            imgs = tensor2imgs(img_tensor, **img_metas[0]['img_norm_cfg'])            assert len(imgs) == len(img_metas)            for img, img_meta in zip(imgs, img_metas):                h, w, _ = img_meta['img_shape']                img_show = img[:h, :w, :]                ori_h, ori_w = img_meta['ori_shape'][:-1]                img_show = mmcv.imresize(img_show, (ori_w, ori_h))                if out_dir:                    out_file = osp.join(out_dir, img_meta['ori_filename'])                else:                    out_file = None                model.module.show_result(                    img_show,                    result,                    palette=dataset.PALETTE,                    show=show,                    out_file=out_file,                    opacity=opacity)        if isinstance(result, list):            if efficient_test:                result = [np2tmp(_, tmpdir='.efficient_test') for _ in result]            results.extend(result)        else:            if efficient_test:                result = np2tmp(result, tmpdir='.efficient_test')            results.append(result)        batch_size = len(result)        for _ in range(batch_size):            prog_bar.update()    return resultsdef multi_gpu_test(model,                   data_loader,                   tmpdir=None,                   gpu_collect=False,                   efficient_test=False):    model.eval()    results = []    dataset = data_loader.dataset    rank, world_size = get_dist_info()    if rank == 0:        prog_bar = mmcv.ProgressBar(len(dataset))    if efficient_test:        mmcv.mkdir_or_exist('.efficient_test')    for i, data in enumerate(data_loader):        with torch.no_grad():            result = model(return_loss=False, rescale=True, **data)        if isinstance(result, list):            if efficient_test:                result = [np2tmp(_, tmpdir='.efficient_test') for _ in result]            results.extend(result)        else:            if efficient_test:                result = np2tmp(result, tmpdir='.efficient_test')            results.append(result)        if rank == 0:            batch_size = len(result)            for _ in range(batch_size * world_size):                prog_bar.update()    # collect results from all ranks    if gpu_collect:        results = collect_results_gpu(results, len(dataset))    else:        results = collect_results_cpu(results, len(dataset), tmpdir)    return results