from collections.abc import Iterableimport numpydef _extend_mode_to_code(mode):    """Convert an extension mode to the corresponding integer code.    """    if mode == 'nearest':        return 0    elif mode == 'wrap':        return 1    elif mode == 'reflect':        return 2    elif mode == 'mirror':        return 3    elif mode == 'constant':        return 4    else:        raise RuntimeError('boundary mode not supported')def _normalize_sequence(input, rank):    """If input is a scalar, create a sequence of length equal to the    rank by duplicating the input. If input is a sequence,    check if its length is equal to the length of array.    """    is_str = isinstance(input, str)    if not is_str and isinstance(input, Iterable):        normalized = list(input)        if len(normalized) != rank:            err = "sequence argument must have length equal to input rank"            raise RuntimeError(err)    else:        normalized = [input] * rank    return normalizeddef _get_output(output, input, shape=None):    if shape is None:        shape = input.shape    if output is None:        output = numpy.zeros(shape, dtype=input.dtype.name)    elif isinstance(output, (type, numpy.dtype)):        # Classes (like `np.float32`) and dtypes are interpreted as dtype        output = numpy.zeros(shape, dtype=output)    elif isinstance(output, str):        output = numpy.typeDict[output]        output = numpy.zeros(shape, dtype=output)    elif output.shape != shape:        raise RuntimeError("output shape not correct")    return output