import numpy as npimport torchclass EvalUtil:    """ Util class for evaluation networks.    """    def __init__(self, num_kp=21):        # init empty data storage        self.data = list()        self.num_kp = num_kp        for _ in range(num_kp):            self.data.append(list())    def feed(self, keypoint_gt, keypoint_pred, keypoint_vis=None):        """        Used to feed data to the class.        Stores the euclidean distance between gt and pred, when it is visible.        """        if isinstance(keypoint_gt, torch.Tensor):            keypoint_gt = keypoint_gt.detach().cpu()            keypoint_gt = keypoint_gt.numpy()        if isinstance(keypoint_pred, torch.Tensor):            keypoint_pred = keypoint_pred.detach().cpu()            keypoint_pred = keypoint_pred.numpy()        keypoint_gt = np.squeeze(keypoint_gt)        keypoint_pred = np.squeeze(keypoint_pred)        if keypoint_vis is None:            keypoint_vis = np.ones_like(keypoint_gt[:, 0])        keypoint_vis = np.squeeze(keypoint_vis).astype("bool")        assert len(keypoint_gt.shape) == 2        assert len(keypoint_pred.shape) == 2        assert len(keypoint_vis.shape) == 1        # calc euclidean distance        diff = keypoint_gt - keypoint_pred        euclidean_dist = np.sqrt(np.sum(np.square(diff), axis=1))        num_kp = keypoint_gt.shape[0]        for i in range(num_kp):            if keypoint_vis[i]:                self.data[i].append(euclidean_dist[i])    def _get_pck(self, kp_id, threshold):        """ Returns pck for one keypoint for the given threshold. """        if len(self.data[kp_id]) == 0:            return None        data = np.array(self.data[kp_id])        pck = np.mean((data <= threshold).astype("float"))        return pck    def get_pck_all(self, threshold):        pckall = []        for kp_id in range(self.num_kp):            pck = self._get_pck(kp_id, threshold)            pckall.append(pck)        pckall = np.mean(np.array(pckall))        return pckall    def _get_epe(self, kp_id):        """ Returns end point error for one keypoint. """        if len(self.data[kp_id]) == 0:            return None, None        data = np.array(self.data[kp_id])        epe_mean = np.mean(data)        epe_median = np.median(data)        return epe_mean, epe_median    def get_measures(self, val_min, val_max, steps):        """ Outputs the average mean and median error as well as the pck score. """        thresholds = np.linspace(val_min, val_max, steps)        thresholds = np.array(thresholds)        norm_factor = np.trapz(np.ones_like(thresholds), thresholds)        # init mean measures        epe_mean_all = list()        epe_median_all = list()        auc_all = list()        pck_curve_all = list()        # Create one plot for each part        for part_id in range(self.num_kp):            # mean/median error            mean, median = self._get_epe(part_id)            if mean is None:                # there was no valid measurement for this keypoint                continue            epe_mean_all.append(mean)            epe_median_all.append(median)            # pck/auc            pck_curve = list()            for t in thresholds:                pck = self._get_pck(part_id, t)                pck_curve.append(pck)            pck_curve = np.array(pck_curve)            pck_curve_all.append(pck_curve)            auc = np.trapz(pck_curve, thresholds)            auc /= norm_factor            auc_all.append(auc)        # Display error per keypoint        epe_mean_joint = epe_mean_all        epe_mean_all = np.mean(np.array(epe_mean_all))        epe_median_all = np.mean(np.array(epe_median_all))        auc_all = np.mean(np.array(auc_all))        pck_curve_all = np.mean(np.array(pck_curve_all), axis=0)  # mean only over keypoints        return (            epe_mean_all,            epe_mean_joint,            epe_median_all,            auc_all,            pck_curve_all,            thresholds,        )