import argparse
import glob
import os
from lib.parser import get_file
from lib.generator import yara_image_rule_maker
from lib.render import yara_print_rule, clam_print_rule



class MFBot:
    """ Malicious File Bot Class """
    def __init__(self) -> None:
        args = MFBot.parse_args()
        self.yara_base_file = args.file
        self.image_name = None
        self.idat = args.idat
        self.jpgsos = args.jpgsos
        self.sof2sos = args.sof2sos
        self.dir = args.dir
        self.jump = args.jump
        self.dirhash = []
        self.name = args.name
        self.container = args.container
        self.clam = args.clam
        self.rprefix = args.rprefix
    @staticmethod
    def parse_args()-> iter:
        """ Parse any options passed to the the script """
        parser_args = argparse.ArgumentParser(description="Halogen:  Automatically create yara \
            rules based on images embedded in office documents.")
        parser_args.add_argument("-f", "--file", help="File to parse")
        parser_args.add_argument("-d", "--directory", dest="dir", help="directory to scan \
            for image files.")
        parser_args.add_argument("-n", "--rule-name", dest="name", help="specify a custom \
            name for the rule file")
        parser_args.add_argument("--png-idat", dest="idat", help="For PNG matches, instead \
            of starting with the PNG file header, start with the IDAT chunk.", action='store_true')
        parser_args.add_argument("--jpg-sos", dest="jpgsos", help="For JPG matches, skip \
            over the header and look for the Start of Scan marker, \
            and begin the match there.", action='store_true')
        parser_args.add_argument("--jpg-sof2sos", dest="sof2sos", help="for JPG matches, \
            skip over the header and match the SOF all the way to the SOS + 45 bytes of the \
            data within the SOS.", action='store_true')
        parser_args.add_argument("--jpg-jump", dest="jump", help="for JPG matches, \
            skip over the header and identify the sof, the sos and then read the actual image data \
            take that data and look for repeated bytes. Skip those bytes and then create 45 bytes of\
            raw image data.", action='store_true')
        parser_args.add_argument("-c", "--container", dest="container", help="specify a clamav container type \
            defaults to CL_TYPE_MSOLE2, CL_TYPE_OOXML_WORD, CL_TYPE_OOXML_XL, CL_TYPE_OOXML_PPT")
        parser_args.add_argument("--clam", dest="clam", help="generate a clam rule instead of a yara rule", action="store_true")
        parser_args.add_argument("--rprefix", dest="rprefix", help="specify a clamav ruleset prefix")        
        args = parser_args.parse_args()
        if (args.file is None) and (args.dir is None):
            parser_args.print_help()
            exit(1)
        return args

    def run(self):
        """mfbot.run() is the core function to call that will return all information
        generated by mfbot.
        returns: rule_dict - dictionary of rules. """
        self.get_file = get_file(self)
        rule_dict = yara_image_rule_maker(self)
        if rule_dict is not None:
            return rule_dict

    def print_yara_rule(self, rule_list):
        """ prints the yara rule by reading in a list of dicts, and iterating over that.
        parameter: rule_list - list of rules to print. """
        yara_print_rule(self, rule_list)
    def print_clam_rule(self, rule_list):
        """ prints the yara rule by reading in a list of dicts, and iterating over that.
        parameter: rule_list - list of rules to print. """
        clam_print_rule(self, rule_list)
    def dir_run(self):
        """ runs through the process with a directory instead of a single file.
        returns: combo list. """
        filelist = glob.glob(self.dir + "/*")
        combo = []
        for f in filelist:
            if os.path.isfile(f):
                self.image_name = None
                self.yara_base_file = f
                self.get_file = get_file(self)
                self.dirhash.append(self.get_file[0])
                rule_dict = yara_image_rule_maker(self)
                if rule_dict is not None:
                    for i in rule_dict:
                        if i not in combo:
                            combo.append(i)
            else:
                pass
        return combo
