# coding=utf-8
# !/usr/bin/env python

from __future__ import print_function
from tabulate import tabulate
from colorama import init
from termcolor import colored
import os
import shutil

init()


def configs(name_data):
    print(name_data)
    data = [
        ['序号', "payload name", "payload", "优点", "缺点", "推荐指数"],
        ['1',
         f"{colored('OpenSSH后门', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('直接写入后门用户,快捷方便,所有系统支持', 'yellow')}",
         f"{colored('容易发现', 'yellow')}",
         f"{colored('***', 'cyan')}",
         ],
        ['2',
         f"{colored('后门用户', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('重置目标服务器的OpenSSH，写入万能密码以及记录ssh明文账户代码', 'yellow')}",
         f"{colored('需要大量的依赖环境，而且只能使用低版本系统，目前经过测试的有乌班图14', 'yellow')}",
         f"{colored('*', 'cyan')}",
         ],
        ['3',
         f"{colored('Alias别名后门', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('使用别名来执行命令或者反弹shell,如执行ls,设置之后,就会反弹shell', 'yellow')}",
         f"{colored('需要当前用户执行命令为常用命令', 'yellow')}",
         f"{colored('* **', 'cyan')}",
         ],
        ['4',
         f"{colored('crontab计划任务', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('设置计划任务来执行反弹shell,其中参考了挖矿病毒计划任务，直接执行crontab来写入 or 写入/etc/crontab文件中', 'yellow')}",
         f"{colored('出网执行反弹shell，在流量会被发现', 'yellow')}",
         f"{colored('****', 'cyan')}",
         ],
        ['5',
         f"{colored('ssh软连接后门', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('快速设置ssh连接，不需要密码', 'yellow')}",
         f"{colored('流量会被发现,以及tmp文件会发现', 'yellow')}",
         f"{colored('*****', 'cyan')}",
         ],
        ['6',
         f"{colored('ssh公私密钥后门', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('快速设置密钥连接，其中参考了挖矿病毒ssh公私密钥，管理员很难发现', 'yellow')}",
         f"{colored('流量会被发现', 'yellow')}",
         f"{colored('******', 'cyan')}",
         ],
        ['7',
         f"{colored('Strace后门', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('键盘记录的后门,记录ssh明文以及密钥', 'yellow')}",
         f"{colored('需要配合权限维持使用', 'yellow')}",
         f"{colored('****', 'cyan')}",
         ],
        ['8',
         f"{colored('Rootkit后门', 'blue')}",
         f"检测",
         f"{colored('很难发现，几乎不可能发现，而且Rootkit后门包括了反弹shell，文件隐藏等', 'yellow')}",
         f"{colored('对于系统版本要求很严格，项目地址：https://github.com/f0rb1dd3n/Reptile/', 'yellow')}",
         f"{colored('****', 'cyan')}",
         ],
        ['9',
         f"{colored('不记录命令[history]', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('命令前加空格不记录命令', 'yellow')}",
         f"{colored('需要在命令前加空格', 'yellow')}",
         f"{colored('******', 'cyan')}",
         ],
        ['10',
         f"{colored('ssh软链接&crontab', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('快速生成软链接[需要运行脚本成功后，一分钟连接]，并且执行计划任务，每分钟判断当前软链接是否存在，如果被kill掉，就重新执行', 'yellow')}",
         f"{colored('流量会被发现', 'yellow')}",
         f"{colored('*****', 'cyan')}",
         ],
        ['11',
         f"{colored('sshkey密钥&crontab', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('判断文件是否存在，判断文件是否加锁，判断文件内容是否符合，每分钟检查一次，不存在的话就重新生成执行', 'yellow')}",
         f"{colored('流量会被发现', 'yellow')}",
         f"{colored('*****', 'cyan')}",
         ],
        ['12',
         f"{colored('php权限维持不死免杀马', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('利用ignore_user_abort函数一直生成文件，同时修改连接命令，加密连接命令', 'yellow')}",
         f"{colored('条件竞争或者重启杀死', 'yellow')}",
         f"{colored('*****', 'cyan')}",
         ],
        ['13',
         f"{colored('check检查脚本', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('快速检测目标机器可以使用那个权限维持payload，并且检测当前机器处于docker还是k8s，并检测docker逃逸', 'yellow')}",
         f"{colored('需要python', 'yellow')}",
         f"{colored('*****', 'cyan')}",
         ],
        ['14',
         f"{colored('Suid shell bash脚本', 'blue')}",
         f"{colored('yes', 'red')}",
         f"{colored('Suid shell bash脚本(低权限用户运行),可以和webshell进行联动一个低权限用户只需要执行一个文件就可以获取高权限', 'yellow')}",
         f"{colored('文件会被发现', 'yellow')}",
         f"{colored('*********', 'cyan')}",
         ],
    ]
    # 获取终端的宽度
    terminal_width, _ = shutil.get_terminal_size()
    # 使用"grid"格式，手动设置列对齐方式
    table = tabulate(data, tablefmt="grid")
    print(table)


def configss(name_data):
    print(name_data)
    data = [
        ['序号', "payload name", "payload"],
        ['1',
         f"{colored('OpenSSH后门', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['2',
         f"{colored('后门用户', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['3',
         f"{colored('Alias后门', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['4',
         f"{colored('crontab计划任务', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['5',
         f"{colored('ssh软链接后门', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['6',
         f"{colored('ssh公私密钥后门', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['7',
         f"{colored('Strace后门', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['8',
         f"{colored('Rootkit后门', 'yellow')}",
         f"{colored('no', 'yellow')}",
         ],
        ['9',
         f"{colored('不记录命令[history]', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['10',
         f"{colored('ssh软链接&crontab', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['11',
         f"{colored('sshkey密钥&crontab', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['12',
         f"{colored('php权限维持不死免杀马', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['13',
         f"{colored('check检查脚本', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
        ['14',
         f"{colored('Suid shell bash脚本(低权限用户运行)', 'cyan')}",
         f"{colored('yes', 'red')}",
         ],
    ]
    # 获取终端的宽度
    terminal_width, _ = shutil.get_terminal_size()
    # 使用"grid"格式，手动设置列对齐方式
    table = tabulate(data, tablefmt="grid")
    print(table)