import magnum as mnimport numpy as npfrom gym import spacesimport habitat_simfrom habitat.articulated_agent_controllers import HumanoidRearrangeControllerfrom habitat.core.registry import registryfrom habitat.tasks.rearrange.actions.actions import (    BaseVelAction,    HumanoidJointAction,)from habitat.tasks.rearrange.utils import place_agent_at_dist_from_posfrom habitat.tasks.utils import get_anglefrom habitat_sim.physics import VelocityControl@registry.register_task_actionclass OracleNavAction(BaseVelAction, HumanoidJointAction):    """    An action that will convert the index of an entity (in the sense of    `PddlEntity`) to navigate to and convert this to base/humanoid joint control to move the    robot to the closest navigable position to that entity. The entity index is    the index into the list of all available entities in the current scene. The    config flag motion_type indicates whether the low level action will be a base_velocity or    a joint control.    """    def __init__(self, *args, task, **kwargs):        config = kwargs["config"]        self.motion_type = config.motion_control        if self.motion_type == "base_velocity":            BaseVelAction.__init__(self, *args, **kwargs)        elif self.motion_type == "human_joints":            HumanoidJointAction.__init__(self, *args, **kwargs)            self.humanoid_controller = self.lazy_inst_humanoid_controller(                task, config            )        else:            raise ValueError("Unrecognized motion type for oracle nav  action")        self._task = task        self._poss_entities = (            self._task.pddl_problem.get_ordered_entities_list()        )        self._prev_ep_id = None        self.skill_done = False        self._targets = {}    @staticmethod    def _compute_turn(rel, turn_vel, robot_forward):        is_left = np.cross(robot_forward, rel) > 0        if is_left:            vel = [0, -turn_vel]        else:            vel = [0, turn_vel]        return vel    def lazy_inst_humanoid_controller(self, task, config):        # Lazy instantiation of humanoid controller        # We assign the task with the humanoid controller, so that multiple actions can        # use it.        if (            not hasattr(task, "humanoid_controller")            or task.humanoid_controller is None        ):            # Initialize humanoid controller            agent_name = self._sim.habitat_config.agents_order[                self._agent_index            ]            walk_pose_path = self._sim.habitat_config.agents[                agent_name            ].motion_data_path            humanoid_controller = HumanoidRearrangeController(walk_pose_path)            humanoid_controller.set_framerate_for_linspeed(                config["lin_speed"], config["ang_speed"], self._sim.ctrl_freq            )            task.humanoid_controller = humanoid_controller        return task.humanoid_controller    def _update_controller_to_navmesh(self):        base_offset = self.cur_articulated_agent.params.base_offset        prev_query_pos = self.cur_articulated_agent.base_pos        target_query_pos = (            self.humanoid_controller.obj_transform_base.translation            + base_offset        )        filtered_query_pos = self._sim.step_filter(            prev_query_pos, target_query_pos        )        fixup = filtered_query_pos - target_query_pos        self.humanoid_controller.obj_transform_base.translation += fixup    @property    def action_space(self):        return spaces.Dict(            {                self._action_arg_prefix                + "oracle_nav_action": spaces.Box(                    shape=(1,),                    low=np.finfo(np.float32).min,                    high=np.finfo(np.float32).max,                    dtype=np.float32,                )            }        )    def reset(self, *args, **kwargs):        super().reset(*args, **kwargs)        if self._task._episode_id != self._prev_ep_id:            self._targets = {}            self._prev_ep_id = self._task._episode_id            self.skill_done = False    def _get_target_for_idx(self, nav_to_target_idx: int):        if nav_to_target_idx not in self._targets:            nav_to_obj = self._poss_entities[nav_to_target_idx]            obj_pos = self._task.pddl_problem.sim_info.get_entity_pos(                nav_to_obj            )            start_pos, _, _ = place_agent_at_dist_from_pos(                np.array(obj_pos),                0.0,                self._config.spawn_max_dist_to_obj,                self._sim,                self._config.num_spawn_attempts,                True,                self.cur_articulated_agent,            )            if self.motion_type == "human_joints":                self.humanoid_controller.reset(                    self.cur_articulated_agent.base_transformation                )            self._targets[nav_to_target_idx] = (                np.array(start_pos),                np.array(obj_pos),            )        return self._targets[nav_to_target_idx]    def _path_to_point(self, point):        """        Obtain path to reach the coordinate point. If agent_pos is not given        the path starts at the agent base pos, otherwise it starts at the agent_pos        value        :param point: Vector3 indicating the target point        """        agent_pos = self.cur_articulated_agent.base_pos        path = habitat_sim.ShortestPath()        path.requested_start = agent_pos        path.requested_end = point        found_path = self._sim.pathfinder.find_path(path)        if not found_path:            return [agent_pos, point]        return path.points    def step(self, *args, **kwargs):        self.skill_done = False        nav_to_target_idx = kwargs[            self._action_arg_prefix + "oracle_nav_action"        ]        if nav_to_target_idx <= 0 or nav_to_target_idx > len(            self._poss_entities        ):            return        nav_to_target_idx = int(nav_to_target_idx[0]) - 1        final_nav_targ, obj_targ_pos = self._get_target_for_idx(            nav_to_target_idx        )        base_T = self.cur_articulated_agent.base_transformation        curr_path_points = self._path_to_point(final_nav_targ)        robot_pos = np.array(self.cur_articulated_agent.base_pos)        if curr_path_points is None:            raise Exception        else:            # Compute distance and angle to target            cur_nav_targ = curr_path_points[1]            forward = np.array([1.0, 0, 0])            robot_forward = np.array(base_T.transform_vector(forward))            # Compute relative target.            rel_targ = cur_nav_targ - robot_pos            # Compute heading angle (2D calculation)            robot_forward = robot_forward[[0, 2]]            rel_targ = rel_targ[[0, 2]]            rel_pos = (obj_targ_pos - robot_pos)[[0, 2]]            angle_to_target = get_angle(robot_forward, rel_targ)            angle_to_obj = get_angle(robot_forward, rel_pos)            dist_to_final_nav_targ = np.linalg.norm(                (final_nav_targ - robot_pos)[[0, 2]]            )            at_goal = (                dist_to_final_nav_targ < self._config.dist_thresh                and angle_to_obj < self._config.turn_thresh            )            if self.motion_type == "base_velocity":                if not at_goal:                    if dist_to_final_nav_targ < self._config.dist_thresh:                        # Look at the object                        vel = OracleNavAction._compute_turn(                            rel_pos, self._config.turn_velocity, robot_forward                        )                    elif angle_to_target < self._config.turn_thresh:                        # Move towards the target                        vel = [self._config.forward_velocity, 0]                    else:                        # Look at the target waypoint.                        vel = OracleNavAction._compute_turn(                            rel_targ, self._config.turn_velocity, robot_forward                        )                else:                    vel = [0, 0]                    self.skill_done = True                kwargs[f"{self._action_arg_prefix}base_vel"] = np.array(vel)                BaseVelAction.step(self, *args, **kwargs)                return            elif self.motion_type == "human_joints":                # Update the humanoid base                self.humanoid_controller.obj_transform_base = base_T                if not at_goal:                    if dist_to_final_nav_targ < self._config.dist_thresh:                        # Look at the object                        self.humanoid_controller.calculate_turn_pose(                            mn.Vector3([rel_pos[0], 0.0, rel_pos[1]])                        )                    else:                        # Move towards the target                        self.humanoid_controller.calculate_walk_pose(                            mn.Vector3([rel_targ[0], 0.0, rel_targ[1]])                        )                else:                    self.humanoid_controller.calculate_stop_pose()                    self.skill_done = True                base_action = self.humanoid_controller.get_pose()                kwargs[                    f"{self._action_arg_prefix}human_joints_trans"                ] = base_action                HumanoidJointAction.step(self, *args, **kwargs)                return            else:                raise ValueError(                    "Unrecognized motion type for oracle nav action"                )class SimpleVelocityControlEnv:    """    Simple velocity control environment for moving agent    """    def __init__(self, sim_freq=120.0):        # the velocity control        self.vel_control = VelocityControl()        self.vel_control.controlling_lin_vel = True        self.vel_control.controlling_ang_vel = True        self.vel_control.lin_vel_is_local = True        self.vel_control.ang_vel_is_local = True        self._sim_freq = sim_freq    def act(self, trans, vel):        linear_velocity = vel[0]        angular_velocity = vel[1]        # Map velocity actions        self.vel_control.linear_velocity = mn.Vector3(            [linear_velocity, 0.0, 0.0]        )        self.vel_control.angular_velocity = mn.Vector3(            [0.0, angular_velocity, 0.0]        )        # Compute the rigid state        rigid_state = habitat_sim.RigidState(            mn.Quaternion.from_matrix(trans.rotation()), trans.translation        )        # Get the target rigit state based on the simulation frequency        target_rigid_state = self.vel_control.integrate_transform(            1 / self._sim_freq, rigid_state        )        # Get the ending pos of the agent        end_pos = target_rigid_state.translation        # Offset the height        end_pos[1] = trans.translation[1]        # Construct the target trans        target_trans = mn.Matrix4.from_(            target_rigid_state.rotation.to_matrix(),            target_rigid_state.translation,        )        return target_trans