# Generated by Django 2.2.9 on 2020-04-28 00:40

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Case",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100, verbose_name="用例名称")),
                ("relation", models.IntegerField(verbose_name="节点id")),
                ("length", models.IntegerField(verbose_name="API个数")),
                (
                    "tag",
                    models.IntegerField(
                        choices=[(1, "冒烟用例"), (2, "集成用例"), (3, "监控脚本")], default=2, verbose_name="用例标签"
                    ),
                ),
            ],
            options={
                "verbose_name": "用例信息",
                "db_table": "case",
            },
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100, unique=True, verbose_name="项目名称")),
                ("desc", models.CharField(max_length=100, verbose_name="简要介绍")),
                ("responsible", models.CharField(max_length=20, verbose_name="创建人")),
            ],
            options={
                "verbose_name": "项目信息",
                "db_table": "project",
            },
        ),
        migrations.CreateModel(
            name="Report",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100, verbose_name="报告名称")),
                (
                    "type",
                    models.IntegerField(
                        choices=[(1, "调试"), (2, "异步"), (3, "定时"), (4, "部署")], verbose_name="报告类型"
                    ),
                ),
                (
                    "status",
                    models.BooleanField(blank=True, choices=[(0, "失败"), (1, "成功")], verbose_name="报告状态"),
                ),
                ("summary", models.TextField(verbose_name="报告基础信息")),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "测试报告",
                "db_table": "report",
            },
        ),
        migrations.CreateModel(
            name="Variables",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("key", models.CharField(max_length=100)),
                ("value", models.CharField(max_length=1024)),
                ("description", models.CharField(max_length=100, null=True, verbose_name="全局变量描述")),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "全局变量",
                "db_table": "variables",
            },
        ),
        migrations.CreateModel(
            name="ReportDetail",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("summary_detail", models.TextField(verbose_name="报告详细信息")),
                (
                    "report",
                    models.OneToOneField(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="fastrunner.Report",
                    ),
                ),
            ],
            options={
                "verbose_name": "测试报告详情",
                "db_table": "report_detail",
            },
        ),
        migrations.CreateModel(
            name="Relation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("tree", models.TextField(default=[], verbose_name="结构主题")),
                ("type", models.IntegerField(default=1, verbose_name="树类型")),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "树形结构关系",
                "db_table": "relation",
            },
        ),
        migrations.CreateModel(
            name="HostIP",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100)),
                ("value", models.TextField()),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "HOST配置",
                "db_table": "host_ip",
            },
        ),
        migrations.CreateModel(
            name="Debugtalk",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("code", models.TextField(default="# write you code", verbose_name="python代码")),
                (
                    "project",
                    models.OneToOneField(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "驱动库",
                "db_table": "debugtalk",
            },
        ),
        migrations.CreateModel(
            name="Config",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100, verbose_name="环境名称")),
                ("body", models.TextField(verbose_name="主体信息")),
                ("base_url", models.CharField(max_length=100, verbose_name="请求地址")),
                ("is_default", models.BooleanField(default=False, verbose_name="默认配置")),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "环境信息",
                "db_table": "config",
            },
        ),
        migrations.CreateModel(
            name="CaseStep",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(max_length=100, verbose_name="用例名称")),
                ("body", models.TextField(verbose_name="主体信息")),
                ("url", models.CharField(max_length=200, verbose_name="请求地址")),
                ("method", models.CharField(max_length=10, verbose_name="请求方式")),
                ("step", models.IntegerField(verbose_name="顺序")),
                ("case", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Case")),
            ],
            options={
                "verbose_name": "用例信息 Step",
                "db_table": "case_step",
            },
        ),
        migrations.AddField(
            model_name="case",
            name="project",
            field=models.ForeignKey(
                db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
            ),
        ),
        migrations.CreateModel(
            name="API",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("create_time", models.DateTimeField(auto_now_add=True, verbose_name="创建时间")),
                ("update_time", models.DateTimeField(auto_now=True, verbose_name="更新时间")),
                ("name", models.CharField(db_index=True, max_length=100, verbose_name="接口名称")),
                ("body", models.TextField(verbose_name="主体信息")),
                ("url", models.CharField(db_index=True, max_length=200, verbose_name="请求地址")),
                ("method", models.CharField(max_length=10, verbose_name="请求方式")),
                ("relation", models.IntegerField(verbose_name="节点id")),
                ("delete", models.IntegerField(default=0, null=True, verbose_name="是否删除")),
                ("rig_id", models.IntegerField(db_index=True, null=True, verbose_name="网关API_id")),
                (
                    "rig_env",
                    models.IntegerField(
                        choices=[(0, "测试环境"), (1, "生产环境"), (2, "预发布 ")], default=0, verbose_name="网关环境"
                    ),
                ),
                (
                    "tag",
                    models.IntegerField(
                        choices=[(0, "还未调试"), (1, "手动成功"), (2, "调试失败"), (3, "自动成功")],
                        default=0,
                        verbose_name="API标签",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to="fastrunner.Project"
                    ),
                ),
            ],
            options={
                "verbose_name": "接口信息",
                "db_table": "api",
            },
        ),
    ]
