"""
Django settings for FasterRunner project.

Generated by 'django-admin startproject' using Django 2.1.

For more information on this file, see
https://docs.djangoproject.com/en/2.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.1/ref/settings/
"""

import datetime as datetime
import os

from loguru import logger

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
# BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(os.path.join(__file__, os.pardir))))
# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "e$od9f28jce8q47u3raik$(e%$@lff6r89ux+=f!e1a$e42+#7"

# SECURITY WARNING: don't run with debug turned on in production!

DEBUG = False


ALLOWED_HOSTS = ["*"]

# Token Settings, 30天过期
INVALID_TIME = 60 * 60 * 24 * 3650

# Application definition

INSTALLED_APPS = [
    "simpleui",
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "fastrunner.apps.FastrunnerConfig",
    "fastuser",
    "rest_framework",
    "corsheaders",
    # 'djcelery',
    "django_celery_beat",
    "rest_framework_swagger",
    "drf_yasg",
    "system",
    "django_auth_ldap",
]

MIDDLEWARE = [
    "fastrunner.utils.middleware.ExceptionMiddleware",
    "django.middleware.gzip.GZipMiddleware",
    "log_request_id.middleware.RequestIDMiddleware",
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "corsheaders.middleware.CorsMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
    "fastrunner.utils.middleware.VisitTimesMiddleware",
]
# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.1/howto/static-files/
STATIC_URL = "/static/"

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, "static")
]  # 指定static文件的路径，缺少这个配置，collect static 无法加载extent.js

STATIC_ROOT = os.path.join(BASE_DIR, "static_root")  # collect static 之后的文件存放路径

ROOT_URLCONF = "FasterRunner.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        # 'DIRS': [os.path.join(BASE_DIR, '../../templates')],
        "DIRS": [os.path.join(BASE_DIR, "./templates")],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "FasterRunner.wsgi.application"

# Password validation
# https://docs.djangoproject.com/en/2.1/ref/settings/#auth-password-valid

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]

# Internationalization
# https://docs.djangoproject.com/en/2.1/topics/i18n/

LANGUAGE_CODE = "zh-Hans"

TIME_ZONE = "Asia/Shanghai"

USE_I18N = True


USE_TZ = False


REST_FRAMEWORK = {
    # 'DEFAULT_AUTHENTICATION_CLASSES': ['FasterRunner.auth.DeleteAuthenticator', 'FasterRunner.auth.Authenticator', ],
    "DEFAULT_AUTHENTICATION_CLASSES": [
        "FasterRunner.auth.MyJWTAuthentication",
    ],
    "UNAUTHENTICATED_USER": None,
    "UNAUTHENTICATED_TOKEN": None,
    # json form 渲染
    "DEFAULT_PARSER_CLASSES": [
        "rest_framework.parsers.JSONParser",
        "rest_framework.parsers.FormParser",
        "rest_framework.parsers.MultiPartParser",
        "rest_framework.parsers.FileUploadParser",
    ],
    "DEFAULT_PAGINATION_CLASS": "FasterRunner.pagination.MyPageNumberPagination",
    "DEFAULT_PERMISSION_CLASSES": ("rest_framework.permissions.AllowAny",),
}
JWT_AUTH = {
    # 'JWT_SECRET_KEY': SECRET_KEY,
    "JWT_EXPIRATION_DELTA": datetime.timedelta(days=30),
    "JWT_ALLOW_REFRESH": True,
}
AUTH_USER_MODEL = "fastuser.MyUser"

SWAGGER_SETTINGS = {
    "DEFAULT_AUTO_SCHEMA_CLASS": "FasterRunner.swagger.CustomSwaggerAutoSchema",
    # 基础样式
    "SECURITY_DEFINITIONS": {
        "basic": {"type": "basic"},
    },
    # 如果需要登录才能够查看接口文档, 登录的链接使用restframework自带的.
    # 'LOGIN_URL': 'rest_framework:login',
    # 'LOGOUT_URL': 'rest_framework:logout',
    # 'DOC_EXPANSION': None,
    # 'SHOW_REQUEST_HEADERS':True,
    # 'USE_SESSION_AUTH': True,
    # 'DOC_EXPANSION': 'list',
    # 接口文档中方法列表以首字母升序排列
    "APIS_SORTER": "alpha",
    # 如果支持json提交, 则接口文档中包含json输入框
    "JSON_EDITOR": True,
    # 方法列表字母排序
    "OPERATIONS_SORTER": "alpha",
    "VALIDATOR_URL": None,
}
CORS_ALLOW_CREDENTIALS = True
CORS_ORIGIN_ALLOW_ALL = True
CORS_ORIGIN_WHITELIST = ()

CORS_ALLOW_METHODS = (
    "DELETE",
    "GET",
    "OPTIONS",
    "PATCH",
    "POST",
    "PUT",
    "VIEW",
)

CORS_ALLOW_HEADERS = (
    "accept",
    "accept-encoding",
    "authorization",
    "content-type",
    "dnt",
    "origin",
    "user-agent",
    "x-csrftoken",
    "x-requested-with",
    "Project",
)
MQ_USER = "admin"
MQ_PASSWORD = "111111"
HOST = "localhost"
DB_NAME = "faster_db"

IM_REPORT_SETTING = {
    "base_url": "http://10.129.144.24",
    "port": 8000,
    "report_title": "自动化测试报告",
}

for level in ["INFO", "WARNING", "ERROR"]:
    logger.add(
        f"logs/{level.lower()}.log",
        format="{time:YYYY-MM-DD HH:mm:ss.SSS}"
        " [pid:{process} -> thread:{thread.name}]"
        " {level}"
        " [{name}:{function}:{line}]"
        " {message}",
        level=level,
        rotation="00:00",
        retention="14 days",
    )

LOGGING = {
    "version": 1,
    "disable_existing_loggers": True,
    "formatters": {
        "standard": {
            "format": "%(levelname)-2s [%(asctime)s] [%(request_id)s] %(name)s [%(filename)s->%(funcName)s:%(lineno)s]:  %(message)s",
        },
        "color": {
            "()": "colorlog.ColoredFormatter",
            "format": "%(green)s%(asctime)s [%(request_id)s] %(name)s %(log_color)s%(levelname)s [pid:%(process)d] "
            "[%(filename)s->%(funcName)s:%(lineno)s] %(cyan)s%(message)s",
            "log_colors": {
                "DEBUG": "black",
                "INFO": "white",
                "WARNING": "yellow",
                "ERROR": "red",
                "CRITICAL": "bold_red",
            },
        },
        # 日志格式
    },
    "filters": {
        "request_id": {"()": "log_request_id.filters.RequestIDFilter"},
        "require_debug_true": {
            "()": "django.utils.log.RequireDebugTrue",  # 过滤器，只有当setting的DEBUG = True时生效
        },
    },
    "handlers": {
        "mail_admins": {
            "level": "ERROR",
            "class": "django.utils.log.AdminEmailHandler",
            "include_html": True,
        },
        "default": {
            "level": "DEBUG",
            "class": "logging.handlers.RotatingFileHandler",
            # 'filename': os.path.join(BASE_DIR, 'logs/../../logs/debug.log'),
            "filename": os.path.join(BASE_DIR, "logs/info.log"),
            "maxBytes": 1024 * 1024 * 50,
            "backupCount": 5,
            "formatter": "color",
            "filters": ["request_id"],
        },
        "error": {
            "level": "ERROR",
            "class": "logging.handlers.RotatingFileHandler",
            # 'filename': os.path.join(BASE_DIR, 'logs/../../logs/debug.log'),
            "filename": os.path.join(BASE_DIR, "logs/error.log"),
            "maxBytes": 1024 * 1024 * 50,
            "backupCount": 5,
            "formatter": "color",
            "filters": ["request_id"],
        },
        "console": {
            "level": "DEBUG",
            "class": "logging.StreamHandler",
            "formatter": "color",
            "filters": ["request_id"],
        },
        "db": {
            "level": "INFO",
            "formatter": "standard",
            "class": "FasterRunner.log.DatabaseLogHandler",  # 指向你的自定义处理器
        },
    },
    "loggers": {
        "django": {
            "handlers": ["default", "console", "error", "db"],
            "level": "INFO",
            "propagate": True,
        },
        "fastrunner": {
            "handlers": ["default", "console", "error", "db"],
            "level": "INFO",
            "propagate": True,
        },
        "httprunner": {
            "handlers": ["default", "console", "error", "db"],
            "level": "INFO",
            "propagate": True,
        },
        "fastuser": {
            "handlers": ["default", "console", "error", "db"],
            "level": "INFO",
            "propagate": True,
        },
        "django_auth_ldap": {
            "handlers": ["default", "console", "error", "db"],
            "level": "INFO",
            "propagate": True,
        },
    },
}
LOG_REQUEST_ID_HEADER = "HTTP_X_REQUEST_ID"
GENERATE_REQUEST_ID_IF_NOT_IN_HEADER = True
REQUEST_ID_RESPONSE_HEADER = "TRACE-ID"


# https://github.com/celery/celery/issues/4796
DJANGO_CELERY_BEAT_TZ_AWARE = False


# 邮箱配置
EMAIL_USE_SSL = True
EMAIL_HOST = os.environ.get("EMAIL_HOST", "smtp.qq.com")  # 如果是 163 改成 smtp.163.com
EMAIL_PORT = os.environ.get("EMAIL_PORT", 465)  # 默认是qq邮箱端口
EMAIL_HOST_USER = os.environ.get("EMAIL_HOST_USER")  # 配置邮箱
EMAIL_HOST_PASSWORD = os.environ.get("EMAIL_HOST_PASSWORD")  # 对应的授权码
DEFAULT_FROM_EMAIL = EMAIL_HOST_USER


# LDAP配置
import ldap
from django_auth_ldap.config import LDAPSearch

USE_LDAP = False  # 如果需要开启LDAP认证，就设置位True

if USE_LDAP:
    AUTHENTICATION_BACKENDS = ("django_auth_ldap.backend.LDAPBackend",)

AUTH_LDAP_SERVER_URI = "ldap://localhost:389"  # LDAP服务器地址，默认端口389

AUTH_LDAP_BIND_DN = "cn=admin,dc=myorg,dc=com"  # LDAP管理员账号
AUTH_LDAP_BIND_PASSWORD = "admin"  # LDAP管理员密码
AUTH_LDAP_USER_SEARCH = LDAPSearch(
    "ou=Tester,dc=myorg,dc=com",
    ldap.SCOPE_SUBTREE,
    "(uid=%(user)s)",
)  # LDAP搜索账号，ou可以理解为组织单位或者部门，不填写也是ok，dc可以理解为域名

AUTH_LDAP_USER_ATTR_MAP = {
    "username": "uid",
    "first_name": "givenName",
    "last_name": "sn",
    "email": "mail",
}

# https://docs.djangoproject.com/en/3.2/ref/settings/#default-auto-field
DEFAULT_AUTO_FIELD = "django.db.models.AutoField"
